// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_online_store_admin_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_FEATURE_ONLINE_STORE_ADMIN_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_FEATURE_ONLINE_STORE_ADMIN_CONNECTION_H

#include "google/cloud/aiplatform/v1/feature_online_store_admin_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace aiplatform_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `FeatureOnlineStoreAdminServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type
 * `FeatureOnlineStoreAdminServiceClient`. To do so, construct an object of type
 * `FeatureOnlineStoreAdminServiceClient` with an instance of this class. Then
 * use the Google Test framework functions to program the behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockFeatureOnlineStoreAdminServiceConnection
    : public aiplatform_v1::FeatureOnlineStoreAdminServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>,
      CreateFeatureOnlineStore,
      (google::cloud::aiplatform::v1::CreateFeatureOnlineStoreRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>,
      GetFeatureOnlineStore,
      (google::cloud::aiplatform::v1::GetFeatureOnlineStoreRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::aiplatform::v1::FeatureOnlineStore>),
      ListFeatureOnlineStores,
      (google::cloud::aiplatform::v1::ListFeatureOnlineStoresRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>,
      UpdateFeatureOnlineStore,
      (google::cloud::aiplatform::v1::UpdateFeatureOnlineStoreRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>,
      DeleteFeatureOnlineStore,
      (google::cloud::aiplatform::v1::DeleteFeatureOnlineStoreRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>,
      CreateFeatureView,
      (google::cloud::aiplatform::v1::CreateFeatureViewRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::FeatureView>, GetFeatureView,
      (google::cloud::aiplatform::v1::GetFeatureViewRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::aiplatform::v1::FeatureView>),
              ListFeatureViews,
              (google::cloud::aiplatform::v1::ListFeatureViewsRequest request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>,
      UpdateFeatureView,
      (google::cloud::aiplatform::v1::UpdateFeatureViewRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>,
      DeleteFeatureView,
      (google::cloud::aiplatform::v1::DeleteFeatureViewRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::SyncFeatureViewResponse>,
      SyncFeatureView,
      (google::cloud::aiplatform::v1::SyncFeatureViewRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::aiplatform::v1::FeatureViewSync>,
      GetFeatureViewSync,
      (google::cloud::aiplatform::v1::GetFeatureViewSyncRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::aiplatform::v1::FeatureViewSync>),
      ListFeatureViewSyncs,
      (google::cloud::aiplatform::v1::ListFeatureViewSyncsRequest request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_MOCKS_MOCK_FEATURE_ONLINE_STORE_ADMIN_CONNECTION_H
