// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_option_defaults.h"
#include "google/cloud/baremetalsolution/v2/bare_metal_solution_connection.h"
#include "google/cloud/baremetalsolution/v2/bare_metal_solution_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace baremetalsolution_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options BareMetalSolutionDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_BARE_METAL_SOLUTION_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_BARE_METAL_SOLUTION_AUTHORITY",
      "baremetalsolution.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options
           .has<baremetalsolution_v2::BareMetalSolutionRetryPolicyOption>()) {
    options.set<baremetalsolution_v2::BareMetalSolutionRetryPolicyOption>(
        baremetalsolution_v2::BareMetalSolutionLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<baremetalsolution_v2::BareMetalSolutionBackoffPolicyOption>()) {
    options.set<baremetalsolution_v2::BareMetalSolutionBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<baremetalsolution_v2::BareMetalSolutionPollingPolicyOption>()) {
    options.set<baremetalsolution_v2::BareMetalSolutionPollingPolicyOption>(
        GenericPollingPolicy<
            baremetalsolution_v2::BareMetalSolutionRetryPolicyOption::Type,
            baremetalsolution_v2::BareMetalSolutionBackoffPolicyOption::Type>(
            options
                .get<baremetalsolution_v2::BareMetalSolutionRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<baremetalsolution_v2::
                       BareMetalSolutionConnectionIdempotencyPolicyOption>()) {
    options.set<baremetalsolution_v2::
                    BareMetalSolutionConnectionIdempotencyPolicyOption>(
        baremetalsolution_v2::
            MakeDefaultBareMetalSolutionConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2_internal
}  // namespace cloud
}  // namespace google
