// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways.proto

#include "google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_external_vpn_gateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExternalVpnGatewaysClient::ExternalVpnGatewaysClient(
    std::shared_ptr<ExternalVpnGatewaysConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ExternalVpnGatewaysClient::~ExternalVpnGatewaysClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::DeleteExternalVpnGateway(
    std::string const& project, std::string const& external_vpn_gateway,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::
      DeleteExternalVpnGatewayRequest request;
  request.set_project(project);
  request.set_external_vpn_gateway(external_vpn_gateway);
  return connection_->DeleteExternalVpnGateway(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::DeleteExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        DeleteExternalVpnGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalVpnGateway(request);
}

StatusOr<google::cloud::cpp::compute::v1::ExternalVpnGateway>
ExternalVpnGatewaysClient::GetExternalVpnGateway(
    std::string const& project, std::string const& external_vpn_gateway,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::
      GetExternalVpnGatewayRequest request;
  request.set_project(project);
  request.set_external_vpn_gateway(external_vpn_gateway);
  return connection_->GetExternalVpnGateway(request);
}

StatusOr<google::cloud::cpp::compute::v1::ExternalVpnGateway>
ExternalVpnGatewaysClient::GetExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        GetExternalVpnGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExternalVpnGateway(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::InsertExternalVpnGateway(
    std::string const& project,
    google::cloud::cpp::compute::v1::ExternalVpnGateway const&
        external_vpn_gateway_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::
      InsertExternalVpnGatewayRequest request;
  request.set_project(project);
  *request.mutable_external_vpn_gateway_resource() =
      external_vpn_gateway_resource;
  return connection_->InsertExternalVpnGateway(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::InsertExternalVpnGateway(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        InsertExternalVpnGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertExternalVpnGateway(request);
}

StreamRange<google::cloud::cpp::compute::v1::ExternalVpnGateway>
ExternalVpnGatewaysClient::ListExternalVpnGateways(std::string const& project,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::
      ListExternalVpnGatewaysRequest request;
  request.set_project(project);
  return connection_->ListExternalVpnGateways(request);
}

StreamRange<google::cloud::cpp::compute::v1::ExternalVpnGateway>
ExternalVpnGatewaysClient::ListExternalVpnGateways(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        ListExternalVpnGatewaysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExternalVpnGateways(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::SetLabels(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::GlobalSetLabelsRequest const&
        global_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::SetLabelsRequest
      request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_global_set_labels_request_resource() =
      global_set_labels_request_resource;
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ExternalVpnGatewaysClient::SetLabels(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ExternalVpnGatewaysClient::TestIamPermissions(
    std::string const& project, std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::external_vpn_gateways::v1::
      TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ExternalVpnGatewaysClient::TestIamPermissions(
    google::cloud::cpp::compute::external_vpn_gateways::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_external_vpn_gateways_v1
}  // namespace cloud
}  // namespace google
