// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/projects/v1/projects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_INTERNAL_PROJECTS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_INTERNAL_PROJECTS_TRACING_CONNECTION_H

#include "google/cloud/compute/projects/v1/projects_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_projects_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ProjectsTracingConnection
    : public compute_projects_v1::ProjectsConnection {
 public:
  ~ProjectsTracingConnection() override = default;

  explicit ProjectsTracingConnection(
      std::shared_ptr<compute_projects_v1::ProjectsConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DisableXpnHost(
      google::cloud::cpp::compute::projects::v1::DisableXpnHostRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DisableXpnResource(google::cloud::cpp::compute::projects::v1::
                         DisableXpnResourceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> EnableXpnHost(
      google::cloud::cpp::compute::projects::v1::EnableXpnHostRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  EnableXpnResource(
      google::cloud::cpp::compute::projects::v1::EnableXpnResourceRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Project> GetProject(
      google::cloud::cpp::compute::projects::v1::GetProjectRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Project> GetXpnHost(
      google::cloud::cpp::compute::projects::v1::GetXpnHostRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::ProjectsGetXpnResources>
  GetXpnResources(
      google::cloud::cpp::compute::projects::v1::GetXpnResourcesRequest const&
          request) override;

  StreamRange<google::cloud::cpp::compute::v1::Project> ListXpnHosts(
      google::cloud::cpp::compute::projects::v1::ListXpnHostsRequest request)
      override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> MoveDisk(
      google::cloud::cpp::compute::projects::v1::MoveDiskRequest const& request)
      override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> MoveInstance(
      google::cloud::cpp::compute::projects::v1::MoveInstanceRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCommonInstanceMetadata(
      google::cloud::cpp::compute::projects::v1::
          SetCommonInstanceMetadataRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetDefaultNetworkTier(
      google::cloud::cpp::compute::projects::v1::
          SetDefaultNetworkTierRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetUsageExportBucket(google::cloud::cpp::compute::projects::v1::
                           SetUsageExportBucketRequest const& request) override;

 private:
  std::shared_ptr<compute_projects_v1::ProjectsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_projects_v1::ProjectsConnection>
MakeProjectsTracingConnection(
    std::shared_ptr<compute_projects_v1::ProjectsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_projects_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PROJECTS_V1_INTERNAL_PROJECTS_TRACING_CONNECTION_H
