// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_instances/v1/target_instances.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_INSTANCES_V1_INTERNAL_TARGET_INSTANCES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_INSTANCES_V1_INTERNAL_TARGET_INSTANCES_TRACING_CONNECTION_H

#include "google/cloud/compute/target_instances/v1/target_instances_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_instances_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class TargetInstancesTracingConnection
    : public compute_target_instances_v1::TargetInstancesConnection {
 public:
  ~TargetInstancesTracingConnection() override = default;

  explicit TargetInstancesTracingConnection(
      std::shared_ptr<compute_target_instances_v1::TargetInstancesConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::TargetInstancesScopedList>>
  AggregatedListTargetInstances(
      google::cloud::cpp::compute::target_instances::v1::
          AggregatedListTargetInstancesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteTargetInstance(google::cloud::cpp::compute::target_instances::v1::
                           DeleteTargetInstanceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetInstance> GetTargetInstance(
      google::cloud::cpp::compute::target_instances::v1::
          GetTargetInstanceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertTargetInstance(google::cloud::cpp::compute::target_instances::v1::
                           InsertTargetInstanceRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetInstance>
  ListTargetInstances(google::cloud::cpp::compute::target_instances::v1::
                          ListTargetInstancesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(google::cloud::cpp::compute::target_instances::v1::
                        SetSecurityPolicyRequest const& request) override;

 private:
  std::shared_ptr<compute_target_instances_v1::TargetInstancesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_target_instances_v1::TargetInstancesConnection>
MakeTargetInstancesTracingConnection(
    std::shared_ptr<compute_target_instances_v1::TargetInstancesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_instances_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_INSTANCES_V1_INTERNAL_TARGET_INSTANCES_TRACING_CONNECTION_H
