// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#include "google/cloud/config/v1/internal/config_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace config_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConfigTracingStub::ConfigTracingStub(std::shared_ptr<ConfigStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::config::v1::ListDeploymentsResponse>
ConfigTracingStub::ListDeployments(
    grpc::ClientContext& context,
    google::cloud::config::v1::ListDeploymentsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ListDeployments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDeployments(context, request));
}

StatusOr<google::cloud::config::v1::Deployment>
ConfigTracingStub::GetDeployment(
    grpc::ClientContext& context,
    google::cloud::config::v1::GetDeploymentRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDeployment(context, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncCreateDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::config::v1::CreateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "CreateDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateDeployment(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncUpdateDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::config::v1::UpdateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UpdateDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateDeployment(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncDeleteDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::config::v1::DeleteDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "DeleteDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteDeployment(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::config::v1::ListRevisionsResponse>
ConfigTracingStub::ListRevisions(
    grpc::ClientContext& context,
    google::cloud::config::v1::ListRevisionsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ListRevisions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRevisions(context, request));
}

StatusOr<google::cloud::config::v1::Revision> ConfigTracingStub::GetRevision(
    grpc::ClientContext& context,
    google::cloud::config::v1::GetRevisionRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetRevision");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRevision(context, request));
}

StatusOr<google::cloud::config::v1::Resource> ConfigTracingStub::GetResource(
    grpc::ClientContext& context,
    google::cloud::config::v1::GetResourceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetResource");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetResource(context, request));
}

StatusOr<google::cloud::config::v1::ListResourcesResponse>
ConfigTracingStub::ListResources(
    grpc::ClientContext& context,
    google::cloud::config::v1::ListResourcesRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ListResources");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListResources(context, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ExportDeploymentStatefile(
    grpc::ClientContext& context,
    google::cloud::config::v1::ExportDeploymentStatefileRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ExportDeploymentStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportDeploymentStatefile(context, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ExportRevisionStatefile(
    grpc::ClientContext& context,
    google::cloud::config::v1::ExportRevisionStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ExportRevisionStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportRevisionStatefile(context, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ImportStatefile(
    grpc::ClientContext& context,
    google::cloud::config::v1::ImportStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ImportStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportStatefile(context, request));
}

Status ConfigTracingStub::DeleteStatefile(
    grpc::ClientContext& context,
    google::cloud::config::v1::DeleteStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "DeleteStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteStatefile(context, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncLockDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::config::v1::LockDeploymentRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "LockDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncLockDeployment(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncUnlockDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::config::v1::UnlockDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UnlockDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUnlockDeployment(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::config::v1::LockInfo> ConfigTracingStub::ExportLockInfo(
    grpc::ClientContext& context,
    google::cloud::config::v1::ExportLockInfoRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ExportLockInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportLockInfo(context, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ConfigTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ConfigStub> MakeConfigTracingStub(
    std::shared_ptr<ConfigStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ConfigTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1_internal
}  // namespace cloud
}  // namespace google
