// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#include "google/cloud/container/v1/cluster_manager_connection.h"
#include "google/cloud/container/v1/cluster_manager_options.h"
#include "google/cloud/container/v1/internal/cluster_manager_connection_impl.h"
#include "google/cloud/container/v1/internal/cluster_manager_option_defaults.h"
#include "google/cloud/container/v1/internal/cluster_manager_stub_factory.h"
#include "google/cloud/container/v1/internal/cluster_manager_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace container_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ClusterManagerConnection::~ClusterManagerConnection() = default;

StatusOr<google::container::v1::ListClustersResponse>
ClusterManagerConnection::ListClusters(
    google::container::v1::ListClustersRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Cluster> ClusterManagerConnection::GetCluster(
    google::container::v1::GetClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::CreateCluster(
    google::container::v1::CreateClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::UpdateCluster(
    google::container::v1::UpdateClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::UpdateNodePool(
    google::container::v1::UpdateNodePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetNodePoolAutoscaling(
    google::container::v1::SetNodePoolAutoscalingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetLoggingService(
    google::container::v1::SetLoggingServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetMonitoringService(
    google::container::v1::SetMonitoringServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetAddonsConfig(
    google::container::v1::SetAddonsConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetLocations(
    google::container::v1::SetLocationsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::UpdateMaster(
    google::container::v1::UpdateMasterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetMasterAuth(
    google::container::v1::SetMasterAuthRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::DeleteCluster(
    google::container::v1::DeleteClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::ListOperationsResponse>
ClusterManagerConnection::ListOperations(
    google::container::v1::ListOperationsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::GetOperation(
    google::container::v1::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ClusterManagerConnection::CancelOperation(
    google::container::v1::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::ServerConfig>
ClusterManagerConnection::GetServerConfig(
    google::container::v1::GetServerConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::GetJSONWebKeysResponse>
ClusterManagerConnection::GetJSONWebKeys(
    google::container::v1::GetJSONWebKeysRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::ListNodePoolsResponse>
ClusterManagerConnection::ListNodePools(
    google::container::v1::ListNodePoolsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::NodePool> ClusterManagerConnection::GetNodePool(
    google::container::v1::GetNodePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::CreateNodePool(
    google::container::v1::CreateNodePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::DeleteNodePool(
    google::container::v1::DeleteNodePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ClusterManagerConnection::CompleteNodePoolUpgrade(
    google::container::v1::CompleteNodePoolUpgradeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::RollbackNodePoolUpgrade(
    google::container::v1::RollbackNodePoolUpgradeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetNodePoolManagement(
    google::container::v1::SetNodePoolManagementRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation> ClusterManagerConnection::SetLabels(
    google::container::v1::SetLabelsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetLegacyAbac(
    google::container::v1::SetLegacyAbacRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::StartIPRotation(
    google::container::v1::StartIPRotationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::CompleteIPRotation(
    google::container::v1::CompleteIPRotationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetNodePoolSize(
    google::container::v1::SetNodePoolSizeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetNetworkPolicy(
    google::container::v1::SetNetworkPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnection::SetMaintenancePolicy(
    google::container::v1::SetMaintenancePolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::container::v1::UsableSubnetwork>
ClusterManagerConnection::ListUsableSubnetworks(
    google::container::v1::
        ListUsableSubnetworksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::container::v1::UsableSubnetwork>>();
}

StatusOr<google::container::v1::CheckAutopilotCompatibilityResponse>
ClusterManagerConnection::CheckAutopilotCompatibility(
    google::container::v1::CheckAutopilotCompatibilityRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ClusterManagerConnection> MakeClusterManagerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ClusterManagerPolicyOptionList>(options,
                                                                 __func__);
  options =
      container_v1_internal::ClusterManagerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = container_v1_internal::CreateDefaultClusterManagerStub(
      background->cq(), options);
  return container_v1_internal::MakeClusterManagerTracingConnection(
      std::make_shared<container_v1_internal::ClusterManagerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container_v1
}  // namespace cloud
}  // namespace google
