// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanager.proto

#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace datacatalog_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PolicyTagManagerTracingStub::PolicyTagManagerTracingStub(
    std::shared_ptr<PolicyTagManagerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingStub::CreateTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateTaxonomyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "CreateTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTaxonomy(context, request));
}

Status PolicyTagManagerTracingStub::DeleteTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteTaxonomyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "DeleteTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTaxonomy(context, request));
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingStub::UpdateTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateTaxonomyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "UpdateTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTaxonomy(context, request));
}

StatusOr<google::cloud::datacatalog::v1::ListTaxonomiesResponse>
PolicyTagManagerTracingStub::ListTaxonomies(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListTaxonomiesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "ListTaxonomies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTaxonomies(context, request));
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerTracingStub::GetTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetTaxonomyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "GetTaxonomy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTaxonomy(context, request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingStub::CreatePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreatePolicyTagRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "CreatePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePolicyTag(context, request));
}

Status PolicyTagManagerTracingStub::DeletePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeletePolicyTagRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "DeletePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePolicyTag(context, request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingStub::UpdatePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdatePolicyTagRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "UpdatePolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdatePolicyTag(context, request));
}

StatusOr<google::cloud::datacatalog::v1::ListPolicyTagsResponse>
PolicyTagManagerTracingStub::ListPolicyTags(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListPolicyTagsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "ListPolicyTags");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPolicyTags(context, request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerTracingStub::GetPolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetPolicyTagRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "GetPolicyTag");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPolicyTag(context, request));
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerTracingStub::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, request));
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerTracingStub::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyTagManagerTracingStub::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.datacatalog.v1.PolicyTagManager", "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TestIamPermissions(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<PolicyTagManagerStub> MakePolicyTagManagerTracingStub(
    std::shared_ptr<PolicyTagManagerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<PolicyTagManagerTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1_internal
}  // namespace cloud
}  // namespace google
