// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/environment.proto

#include "google/cloud/dialogflow_es/environments_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EnvironmentsClient::EnvironmentsClient(
    std::shared_ptr<EnvironmentsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EnvironmentsClient::~EnvironmentsClient() = default;

StreamRange<google::cloud::dialogflow::v2::Environment>
EnvironmentsClient::ListEnvironments(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListEnvironmentsRequest request;
  request.set_parent(parent);
  return connection_->ListEnvironments(request);
}

StreamRange<google::cloud::dialogflow::v2::Environment>
EnvironmentsClient::ListEnvironments(
    google::cloud::dialogflow::v2::ListEnvironmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEnvironments(std::move(request));
}

StatusOr<google::cloud::dialogflow::v2::Environment>
EnvironmentsClient::GetEnvironment(
    google::cloud::dialogflow::v2::GetEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEnvironment(request);
}

StatusOr<google::cloud::dialogflow::v2::Environment>
EnvironmentsClient::CreateEnvironment(
    google::cloud::dialogflow::v2::CreateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(request);
}

StatusOr<google::cloud::dialogflow::v2::Environment>
EnvironmentsClient::UpdateEnvironment(
    google::cloud::dialogflow::v2::UpdateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEnvironment(request);
}

Status EnvironmentsClient::DeleteEnvironment(
    google::cloud::dialogflow::v2::DeleteEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(request);
}

StreamRange<google::cloud::dialogflow::v2::EnvironmentHistory::Entry>
EnvironmentsClient::GetEnvironmentHistory(
    google::cloud::dialogflow::v2::GetEnvironmentHistoryRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEnvironmentHistory(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
