// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_H

#include "google/cloud/documentai/v1/document_processor_connection_idempotency_policy.h"
#include "google/cloud/documentai/v1/internal/document_processor_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/documentai/v1/document_processor_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace documentai_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `DocumentProcessorServiceConnection`.
class DocumentProcessorServiceRetryPolicy
    : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<DocumentProcessorServiceRetryPolicy> clone()
      const = 0;
};

/**
 * A retry policy for `DocumentProcessorServiceConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class DocumentProcessorServiceLimitedErrorCountRetryPolicy
    : public DocumentProcessorServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit DocumentProcessorServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  DocumentProcessorServiceLimitedErrorCountRetryPolicy(
      DocumentProcessorServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : DocumentProcessorServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  DocumentProcessorServiceLimitedErrorCountRetryPolicy(
      DocumentProcessorServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : DocumentProcessorServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<DocumentProcessorServiceRetryPolicy> clone() const override {
    return std::make_unique<
        DocumentProcessorServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = DocumentProcessorServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      documentai_v1_internal::DocumentProcessorServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `DocumentProcessorServiceConnection` based on elapsed
 * time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class DocumentProcessorServiceLimitedTimeRetryPolicy
    : public DocumentProcessorServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit DocumentProcessorServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  DocumentProcessorServiceLimitedTimeRetryPolicy(
      DocumentProcessorServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : DocumentProcessorServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {
  }
  DocumentProcessorServiceLimitedTimeRetryPolicy(
      DocumentProcessorServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : DocumentProcessorServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {
  }

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<DocumentProcessorServiceRetryPolicy> clone() const override {
    return std::make_unique<DocumentProcessorServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = DocumentProcessorServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      documentai_v1_internal::DocumentProcessorServiceRetryTraits>
      impl_;
};

/**
 * The `DocumentProcessorServiceConnection` object for
 * `DocumentProcessorServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `DocumentProcessorServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `DocumentProcessorServiceClient`.
 *
 * To create a concrete instance, see
 * `MakeDocumentProcessorServiceConnection()`.
 *
 * For mocking, see
 * `documentai_v1_mocks::MockDocumentProcessorServiceConnection`.
 */
class DocumentProcessorServiceConnection {
 public:
  virtual ~DocumentProcessorServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::documentai::v1::ProcessResponse>
  ProcessDocument(google::cloud::documentai::v1::ProcessRequest const& request);

  virtual future<StatusOr<google::cloud::documentai::v1::BatchProcessResponse>>
  BatchProcessDocuments(
      google::cloud::documentai::v1::BatchProcessRequest const& request);

  virtual StatusOr<google::cloud::documentai::v1::FetchProcessorTypesResponse>
  FetchProcessorTypes(
      google::cloud::documentai::v1::FetchProcessorTypesRequest const& request);

  virtual StreamRange<google::cloud::documentai::v1::ProcessorType>
  ListProcessorTypes(
      google::cloud::documentai::v1::ListProcessorTypesRequest request);

  virtual StatusOr<google::cloud::documentai::v1::ProcessorType>
  GetProcessorType(
      google::cloud::documentai::v1::GetProcessorTypeRequest const& request);

  virtual StreamRange<google::cloud::documentai::v1::Processor> ListProcessors(
      google::cloud::documentai::v1::ListProcessorsRequest request);

  virtual StatusOr<google::cloud::documentai::v1::Processor> GetProcessor(
      google::cloud::documentai::v1::GetProcessorRequest const& request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::TrainProcessorVersionResponse>>
  TrainProcessorVersion(
      google::cloud::documentai::v1::TrainProcessorVersionRequest const&
          request);

  virtual StatusOr<google::cloud::documentai::v1::ProcessorVersion>
  GetProcessorVersion(
      google::cloud::documentai::v1::GetProcessorVersionRequest const& request);

  virtual StreamRange<google::cloud::documentai::v1::ProcessorVersion>
  ListProcessorVersions(
      google::cloud::documentai::v1::ListProcessorVersionsRequest request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::DeleteProcessorVersionMetadata>>
  DeleteProcessorVersion(
      google::cloud::documentai::v1::DeleteProcessorVersionRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::DeployProcessorVersionResponse>>
  DeployProcessorVersion(
      google::cloud::documentai::v1::DeployProcessorVersionRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::UndeployProcessorVersionResponse>>
  UndeployProcessorVersion(
      google::cloud::documentai::v1::UndeployProcessorVersionRequest const&
          request);

  virtual StatusOr<google::cloud::documentai::v1::Processor> CreateProcessor(
      google::cloud::documentai::v1::CreateProcessorRequest const& request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::DeleteProcessorMetadata>>
  DeleteProcessor(
      google::cloud::documentai::v1::DeleteProcessorRequest const& request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::EnableProcessorResponse>>
  EnableProcessor(
      google::cloud::documentai::v1::EnableProcessorRequest const& request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::DisableProcessorResponse>>
  DisableProcessor(
      google::cloud::documentai::v1::DisableProcessorRequest const& request);

  virtual future<StatusOr<
      google::cloud::documentai::v1::SetDefaultProcessorVersionResponse>>
  SetDefaultProcessorVersion(
      google::cloud::documentai::v1::SetDefaultProcessorVersionRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::ReviewDocumentResponse>>
  ReviewDocument(
      google::cloud::documentai::v1::ReviewDocumentRequest const& request);

  virtual future<
      StatusOr<google::cloud::documentai::v1::EvaluateProcessorVersionResponse>>
  EvaluateProcessorVersion(
      google::cloud::documentai::v1::EvaluateProcessorVersionRequest const&
          request);

  virtual StatusOr<google::cloud::documentai::v1::Evaluation> GetEvaluation(
      google::cloud::documentai::v1::GetEvaluationRequest const& request);

  virtual StreamRange<google::cloud::documentai::v1::Evaluation>
  ListEvaluations(
      google::cloud::documentai::v1::ListEvaluationsRequest request);
};

/**
 * A factory function to construct an object of type
 * `DocumentProcessorServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * DocumentProcessorServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `DocumentProcessorServiceConnection`. Expected options are any of
 * the types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::documentai_v1::DocumentProcessorServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param location Sets the prefix for the default `EndpointOption` value.
 * @param options (optional) Configure the `DocumentProcessorServiceConnection`
 * created by this function.
 */
std::shared_ptr<DocumentProcessorServiceConnection>
MakeDocumentProcessorServiceConnection(std::string const& location,
                                       Options options = {});

/**
 * A backwards-compatible version of the previous factory function.  Unless
 * the service also offers a global endpoint, the default value of the
 * `EndpointOption` may be useless, in which case it must be overridden.
 *
 * @deprecated Please use the `location` overload instead.
 */
std::shared_ptr<DocumentProcessorServiceConnection>
MakeDocumentProcessorServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DOCUMENTAI_V1_DOCUMENT_PROCESSOR_CONNECTION_H
