// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/internal/function_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FunctionServiceTracingConnection::FunctionServiceTracingConnection(
    std::shared_ptr<functions_v2::FunctionServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceTracingConnection::GetFunction(
    google::cloud::functions::v2::GetFunctionRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::GetFunction");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFunction(request));
}

StreamRange<google::cloud::functions::v2::Function>
FunctionServiceTracingConnection::ListFunctions(
    google::cloud::functions::v2::ListFunctionsRequest request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::ListFunctions");
  internal::OTelScope scope(span);
  auto sr = child_->ListFunctions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::functions::v2::Function>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceTracingConnection::CreateFunction(
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::CreateFunction");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateFunction(request));
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceTracingConnection::UpdateFunction(
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::UpdateFunction");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFunction(request));
}

future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
FunctionServiceTracingConnection::DeleteFunction(
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::DeleteFunction");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFunction(request));
}

StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
FunctionServiceTracingConnection::GenerateUploadUrl(
    google::cloud::functions::v2::GenerateUploadUrlRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::GenerateUploadUrl");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateUploadUrl(request));
}

StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
FunctionServiceTracingConnection::GenerateDownloadUrl(
    google::cloud::functions::v2::GenerateDownloadUrlRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::GenerateDownloadUrl");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateDownloadUrl(request));
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceTracingConnection::ListRuntimes(
    google::cloud::functions::v2::ListRuntimesRequest const& request) {
  auto span = internal::MakeSpan(
      "functions_v2::FunctionServiceConnection::ListRuntimes");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ListRuntimes(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<functions_v2::FunctionServiceConnection>
MakeFunctionServiceTracingConnection(
    std::shared_ptr<functions_v2::FunctionServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<FunctionServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2_internal
}  // namespace cloud
}  // namespace google
