// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/gke_hub_connection.h"
#include "google/cloud/gkehub/v1/gke_hub_options.h"
#include "google/cloud/gkehub/v1/internal/gke_hub_connection_impl.h"
#include "google/cloud/gkehub/v1/internal/gke_hub_option_defaults.h"
#include "google/cloud/gkehub/v1/internal/gke_hub_stub_factory.h"
#include "google/cloud/gkehub/v1/internal/gke_hub_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkehub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GkeHubConnection::~GkeHubConnection() = default;

StreamRange<google::cloud::gkehub::v1::Membership>
GkeHubConnection::ListMemberships(
    google::cloud::gkehub::v1::
        ListMembershipsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkehub::v1::Membership>>();
}

StreamRange<google::cloud::gkehub::v1::Feature> GkeHubConnection::ListFeatures(
    google::cloud::gkehub::v1::
        ListFeaturesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::gkehub::v1::Feature>>();
}

StatusOr<google::cloud::gkehub::v1::Membership> GkeHubConnection::GetMembership(
    google::cloud::gkehub::v1::GetMembershipRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gkehub::v1::Feature> GkeHubConnection::GetFeature(
    google::cloud::gkehub::v1::GetFeatureRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnection::CreateMembership(
    google::cloud::gkehub::v1::CreateMembershipRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::Membership>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnection::CreateFeature(
    google::cloud::gkehub::v1::CreateFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnection::DeleteMembership(
    google::cloud::gkehub::v1::DeleteMembershipRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnection::DeleteFeature(
    google::cloud::gkehub::v1::DeleteFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnection::UpdateMembership(
    google::cloud::gkehub::v1::UpdateMembershipRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::Membership>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnection::UpdateFeature(
    google::cloud::gkehub::v1::UpdateFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gkehub::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
GkeHubConnection::GenerateConnectManifest(
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<GkeHubConnection> MakeGkeHubConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 GkeHubPolicyOptionList>(options, __func__);
  options = gkehub_v1_internal::GkeHubDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      gkehub_v1_internal::CreateDefaultGkeHubStub(background->cq(), options);
  return gkehub_v1_internal::MakeGkeHubTracingConnection(
      std::make_shared<gkehub_v1_internal::GkeHubConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1
}  // namespace cloud
}  // namespace google
