// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/snooze_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SnoozeServiceClient::SnoozeServiceClient(
    std::shared_ptr<SnoozeServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SnoozeServiceClient::~SnoozeServiceClient() = default;

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::CreateSnooze(
    std::string const& parent, google::monitoring::v3::Snooze const& snooze,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::CreateSnoozeRequest request;
  request.set_parent(parent);
  *request.mutable_snooze() = snooze;
  return connection_->CreateSnooze(request);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::CreateSnooze(
    google::monitoring::v3::CreateSnoozeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnooze(request);
}

StreamRange<google::monitoring::v3::Snooze> SnoozeServiceClient::ListSnoozes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::ListSnoozesRequest request;
  request.set_parent(parent);
  return connection_->ListSnoozes(request);
}

StreamRange<google::monitoring::v3::Snooze> SnoozeServiceClient::ListSnoozes(
    google::monitoring::v3::ListSnoozesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSnoozes(std::move(request));
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::GetSnooze(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::GetSnoozeRequest request;
  request.set_name(name);
  return connection_->GetSnooze(request);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::GetSnooze(
    google::monitoring::v3::GetSnoozeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSnooze(request);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::UpdateSnooze(
    google::monitoring::v3::Snooze const& snooze,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::UpdateSnoozeRequest request;
  *request.mutable_snooze() = snooze;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSnooze(request);
}

StatusOr<google::monitoring::v3::Snooze> SnoozeServiceClient::UpdateSnooze(
    google::monitoring::v3::UpdateSnoozeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSnooze(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
