// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#include "google/cloud/netapp/v1/net_app_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace netapp_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetAppClient::NetAppClient(std::shared_ptr<NetAppConnection> connection,
                           Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NetAppClient::~NetAppClient() = default;

StreamRange<google::cloud::netapp::v1::StoragePool>
NetAppClient::ListStoragePools(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListStoragePoolsRequest request;
  request.set_parent(parent);
  return connection_->ListStoragePools(request);
}

StreamRange<google::cloud::netapp::v1::StoragePool>
NetAppClient::ListStoragePools(
    google::cloud::netapp::v1::ListStoragePoolsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListStoragePools(std::move(request));
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppClient::CreateStoragePool(
    std::string const& parent,
    google::cloud::netapp::v1::StoragePool const& storage_pool,
    std::string const& storage_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateStoragePoolRequest request;
  request.set_parent(parent);
  *request.mutable_storage_pool() = storage_pool;
  request.set_storage_pool_id(storage_pool_id);
  return connection_->CreateStoragePool(request);
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppClient::CreateStoragePool(
    google::cloud::netapp::v1::CreateStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateStoragePool(request);
}

StatusOr<google::cloud::netapp::v1::StoragePool> NetAppClient::GetStoragePool(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetStoragePoolRequest request;
  request.set_name(name);
  return connection_->GetStoragePool(request);
}

StatusOr<google::cloud::netapp::v1::StoragePool> NetAppClient::GetStoragePool(
    google::cloud::netapp::v1::GetStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetStoragePool(request);
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppClient::UpdateStoragePool(
    google::cloud::netapp::v1::StoragePool const& storage_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateStoragePoolRequest request;
  *request.mutable_storage_pool() = storage_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateStoragePool(request);
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppClient::UpdateStoragePool(
    google::cloud::netapp::v1::UpdateStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateStoragePool(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteStoragePool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteStoragePoolRequest request;
  request.set_name(name);
  return connection_->DeleteStoragePool(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteStoragePool(
    google::cloud::netapp::v1::DeleteStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteStoragePool(request);
}

StreamRange<google::cloud::netapp::v1::Volume> NetAppClient::ListVolumes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListVolumesRequest request;
  request.set_parent(parent);
  return connection_->ListVolumes(request);
}

StreamRange<google::cloud::netapp::v1::Volume> NetAppClient::ListVolumes(
    google::cloud::netapp::v1::ListVolumesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVolumes(std::move(request));
}

StatusOr<google::cloud::netapp::v1::Volume> NetAppClient::GetVolume(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetVolumeRequest request;
  request.set_name(name);
  return connection_->GetVolume(request);
}

StatusOr<google::cloud::netapp::v1::Volume> NetAppClient::GetVolume(
    google::cloud::netapp::v1::GetVolumeRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::Volume>> NetAppClient::CreateVolume(
    std::string const& parent, google::cloud::netapp::v1::Volume const& volume,
    std::string const& volume_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateVolumeRequest request;
  request.set_parent(parent);
  *request.mutable_volume() = volume;
  request.set_volume_id(volume_id);
  return connection_->CreateVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::Volume>> NetAppClient::CreateVolume(
    google::cloud::netapp::v1::CreateVolumeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::Volume>> NetAppClient::UpdateVolume(
    google::cloud::netapp::v1::Volume const& volume,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateVolumeRequest request;
  *request.mutable_volume() = volume;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::Volume>> NetAppClient::UpdateVolume(
    google::cloud::netapp::v1::UpdateVolumeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteVolume(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteVolumeRequest request;
  request.set_name(name);
  return connection_->DeleteVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteVolume(
    google::cloud::netapp::v1::DeleteVolumeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVolume(request);
}

future<StatusOr<google::cloud::netapp::v1::Volume>> NetAppClient::RevertVolume(
    google::cloud::netapp::v1::RevertVolumeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevertVolume(request);
}

StreamRange<google::cloud::netapp::v1::Snapshot> NetAppClient::ListSnapshots(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListSnapshotsRequest request;
  request.set_parent(parent);
  return connection_->ListSnapshots(request);
}

StreamRange<google::cloud::netapp::v1::Snapshot> NetAppClient::ListSnapshots(
    google::cloud::netapp::v1::ListSnapshotsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSnapshots(std::move(request));
}

StatusOr<google::cloud::netapp::v1::Snapshot> NetAppClient::GetSnapshot(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetSnapshotRequest request;
  request.set_name(name);
  return connection_->GetSnapshot(request);
}

StatusOr<google::cloud::netapp::v1::Snapshot> NetAppClient::GetSnapshot(
    google::cloud::netapp::v1::GetSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppClient::CreateSnapshot(
    std::string const& parent,
    google::cloud::netapp::v1::Snapshot const& snapshot,
    std::string const& snapshot_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateSnapshotRequest request;
  request.set_parent(parent);
  *request.mutable_snapshot() = snapshot;
  request.set_snapshot_id(snapshot_id);
  return connection_->CreateSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppClient::CreateSnapshot(
    google::cloud::netapp::v1::CreateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteSnapshot(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteSnapshotRequest request;
  request.set_name(name);
  return connection_->DeleteSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteSnapshot(
    google::cloud::netapp::v1::DeleteSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppClient::UpdateSnapshot(
    google::cloud::netapp::v1::Snapshot const& snapshot,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateSnapshotRequest request;
  *request.mutable_snapshot() = snapshot;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSnapshot(request);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppClient::UpdateSnapshot(
    google::cloud::netapp::v1::UpdateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSnapshot(request);
}

StreamRange<google::cloud::netapp::v1::ActiveDirectory>
NetAppClient::ListActiveDirectories(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListActiveDirectoriesRequest request;
  request.set_parent(parent);
  return connection_->ListActiveDirectories(request);
}

StreamRange<google::cloud::netapp::v1::ActiveDirectory>
NetAppClient::ListActiveDirectories(
    google::cloud::netapp::v1::ListActiveDirectoriesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListActiveDirectories(std::move(request));
}

StatusOr<google::cloud::netapp::v1::ActiveDirectory>
NetAppClient::GetActiveDirectory(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetActiveDirectoryRequest request;
  request.set_name(name);
  return connection_->GetActiveDirectory(request);
}

StatusOr<google::cloud::netapp::v1::ActiveDirectory>
NetAppClient::GetActiveDirectory(
    google::cloud::netapp::v1::GetActiveDirectoryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppClient::CreateActiveDirectory(
    std::string const& parent,
    google::cloud::netapp::v1::ActiveDirectory const& active_directory,
    std::string const& active_directory_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateActiveDirectoryRequest request;
  request.set_parent(parent);
  *request.mutable_active_directory() = active_directory;
  request.set_active_directory_id(active_directory_id);
  return connection_->CreateActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppClient::CreateActiveDirectory(
    google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppClient::UpdateActiveDirectory(
    google::cloud::netapp::v1::ActiveDirectory const& active_directory,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateActiveDirectoryRequest request;
  *request.mutable_active_directory() = active_directory;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppClient::UpdateActiveDirectory(
    google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteActiveDirectory(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteActiveDirectoryRequest request;
  request.set_name(name);
  return connection_->DeleteActiveDirectory(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteActiveDirectory(
    google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteActiveDirectory(request);
}

StreamRange<google::cloud::netapp::v1::KmsConfig> NetAppClient::ListKmsConfigs(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListKmsConfigsRequest request;
  request.set_parent(parent);
  return connection_->ListKmsConfigs(request);
}

StreamRange<google::cloud::netapp::v1::KmsConfig> NetAppClient::ListKmsConfigs(
    google::cloud::netapp::v1::ListKmsConfigsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListKmsConfigs(std::move(request));
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppClient::CreateKmsConfig(
    std::string const& parent,
    google::cloud::netapp::v1::KmsConfig const& kms_config,
    std::string const& kms_config_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateKmsConfigRequest request;
  request.set_parent(parent);
  *request.mutable_kms_config() = kms_config;
  request.set_kms_config_id(kms_config_id);
  return connection_->CreateKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppClient::CreateKmsConfig(
    google::cloud::netapp::v1::CreateKmsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKmsConfig(request);
}

StatusOr<google::cloud::netapp::v1::KmsConfig> NetAppClient::GetKmsConfig(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetKmsConfigRequest request;
  request.set_name(name);
  return connection_->GetKmsConfig(request);
}

StatusOr<google::cloud::netapp::v1::KmsConfig> NetAppClient::GetKmsConfig(
    google::cloud::netapp::v1::GetKmsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppClient::UpdateKmsConfig(
    google::cloud::netapp::v1::KmsConfig const& kms_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateKmsConfigRequest request;
  *request.mutable_kms_config() = kms_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppClient::UpdateKmsConfig(
    google::cloud::netapp::v1::UpdateKmsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppClient::EncryptVolumes(
    google::cloud::netapp::v1::EncryptVolumesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EncryptVolumes(request);
}

StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse>
NetAppClient::VerifyKmsConfig(
    google::cloud::netapp::v1::VerifyKmsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->VerifyKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteKmsConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteKmsConfigRequest request;
  request.set_name(name);
  return connection_->DeleteKmsConfig(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteKmsConfig(
    google::cloud::netapp::v1::DeleteKmsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteKmsConfig(request);
}

StreamRange<google::cloud::netapp::v1::Replication>
NetAppClient::ListReplications(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::ListReplicationsRequest request;
  request.set_parent(parent);
  return connection_->ListReplications(request);
}

StreamRange<google::cloud::netapp::v1::Replication>
NetAppClient::ListReplications(
    google::cloud::netapp::v1::ListReplicationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReplications(std::move(request));
}

StatusOr<google::cloud::netapp::v1::Replication> NetAppClient::GetReplication(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::GetReplicationRequest request;
  request.set_name(name);
  return connection_->GetReplication(request);
}

StatusOr<google::cloud::netapp::v1::Replication> NetAppClient::GetReplication(
    google::cloud::netapp::v1::GetReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::CreateReplication(
    std::string const& parent,
    google::cloud::netapp::v1::Replication const& replication,
    std::string const& replication_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::CreateReplicationRequest request;
  request.set_parent(parent);
  *request.mutable_replication() = replication;
  request.set_replication_id(replication_id);
  return connection_->CreateReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::CreateReplication(
    google::cloud::netapp::v1::CreateReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteReplication(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::DeleteReplicationRequest request;
  request.set_name(name);
  return connection_->DeleteReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppClient::DeleteReplication(
    google::cloud::netapp::v1::DeleteReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::UpdateReplication(
    google::cloud::netapp::v1::Replication const& replication,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::netapp::v1::UpdateReplicationRequest request;
  *request.mutable_replication() = replication;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::UpdateReplication(
    google::cloud::netapp::v1::UpdateReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::StopReplication(
    google::cloud::netapp::v1::StopReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::ResumeReplication(
    google::cloud::netapp::v1::ResumeReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeReplication(request);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppClient::ReverseReplicationDirection(
    google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReverseReplicationDirection(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1
}  // namespace cloud
}  // namespace google
