// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#include "google/cloud/privateca/v1/certificate_authority_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace privateca_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CertificateAuthorityServiceConnectionIdempotencyPolicy::
    ~CertificateAuthorityServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<CertificateAuthorityServiceConnectionIdempotencyPolicy>
CertificateAuthorityServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<
      CertificateAuthorityServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::CreateCertificate(
    google::cloud::security::privateca::v1::CreateCertificateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::GetCertificate(
    google::cloud::security::privateca::v1::GetCertificateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::ListCertificates(
    google::cloud::security::privateca::v1::
        ListCertificatesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::RevokeCertificate(
    google::cloud::security::privateca::v1::RevokeCertificateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::UpdateCertificate(
    google::cloud::security::privateca::v1::UpdateCertificateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    ActivateCertificateAuthority(
        google::cloud::security::privateca::v1::
            ActivateCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    CreateCertificateAuthority(google::cloud::security::privateca::v1::
                                   CreateCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    DisableCertificateAuthority(google::cloud::security::privateca::v1::
                                    DisableCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    EnableCertificateAuthority(google::cloud::security::privateca::v1::
                                   EnableCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    FetchCertificateAuthorityCsr(
        google::cloud::security::privateca::v1::
            FetchCertificateAuthorityCsrRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::GetCertificateAuthority(
    google::cloud::security::privateca::v1::
        GetCertificateAuthorityRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    ListCertificateAuthorities(
        google::cloud::security::privateca::v1::
            ListCertificateAuthoritiesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    UndeleteCertificateAuthority(
        google::cloud::security::privateca::v1::
            UndeleteCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    DeleteCertificateAuthority(google::cloud::security::privateca::v1::
                                   DeleteCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    UpdateCertificateAuthority(google::cloud::security::privateca::v1::
                                   UpdateCertificateAuthorityRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::CreateCaPool(
    google::cloud::security::privateca::v1::CreateCaPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::UpdateCaPool(
    google::cloud::security::privateca::v1::UpdateCaPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::GetCaPool(
    google::cloud::security::privateca::v1::GetCaPoolRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::ListCaPools(
    google::cloud::security::privateca::v1::ListCaPoolsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::DeleteCaPool(
    google::cloud::security::privateca::v1::DeleteCaPoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::FetchCaCerts(
    google::cloud::security::privateca::v1::FetchCaCertsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    GetCertificateRevocationList(
        google::cloud::security::privateca::v1::
            GetCertificateRevocationListRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    ListCertificateRevocationLists(
        google::cloud::security::privateca::v1::
            ListCertificateRevocationListsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    UpdateCertificateRevocationList(
        google::cloud::security::privateca::v1::
            UpdateCertificateRevocationListRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    CreateCertificateTemplate(google::cloud::security::privateca::v1::
                                  CreateCertificateTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    DeleteCertificateTemplate(google::cloud::security::privateca::v1::
                                  DeleteCertificateTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
CertificateAuthorityServiceConnectionIdempotencyPolicy::GetCertificateTemplate(
    google::cloud::security::privateca::v1::
        GetCertificateTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    ListCertificateTemplates(google::cloud::security::privateca::v1::
                                 ListCertificateTemplatesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CertificateAuthorityServiceConnectionIdempotencyPolicy::
    UpdateCertificateTemplate(google::cloud::security::privateca::v1::
                                  UpdateCertificateTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CertificateAuthorityServiceConnectionIdempotencyPolicy>
MakeDefaultCertificateAuthorityServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      CertificateAuthorityServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1
}  // namespace cloud
}  // namespace google
