// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#include "google/cloud/recommender/v1/internal/recommender_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/recommender/v1/recommender_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace recommender_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RecommenderStub::~RecommenderStub() = default;

StatusOr<google::cloud::recommender::v1::ListInsightsResponse>
DefaultRecommenderStub::ListInsights(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::ListInsightsRequest const& request) {
  google::cloud::recommender::v1::ListInsightsResponse response;
  auto status = grpc_stub_->ListInsights(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Insight>
DefaultRecommenderStub::GetInsight(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetInsightRequest const& request) {
  google::cloud::recommender::v1::Insight response;
  auto status = grpc_stub_->GetInsight(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Insight>
DefaultRecommenderStub::MarkInsightAccepted(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkInsightAcceptedRequest const& request) {
  google::cloud::recommender::v1::Insight response;
  auto status = grpc_stub_->MarkInsightAccepted(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::ListRecommendationsResponse>
DefaultRecommenderStub::ListRecommendations(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::ListRecommendationsRequest const& request) {
  google::cloud::recommender::v1::ListRecommendationsResponse response;
  auto status = grpc_stub_->ListRecommendations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Recommendation>
DefaultRecommenderStub::GetRecommendation(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetRecommendationRequest const& request) {
  google::cloud::recommender::v1::Recommendation response;
  auto status = grpc_stub_->GetRecommendation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Recommendation>
DefaultRecommenderStub::MarkRecommendationDismissed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationDismissedRequest const&
        request) {
  google::cloud::recommender::v1::Recommendation response;
  auto status =
      grpc_stub_->MarkRecommendationDismissed(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Recommendation>
DefaultRecommenderStub::MarkRecommendationClaimed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&
        request) {
  google::cloud::recommender::v1::Recommendation response;
  auto status =
      grpc_stub_->MarkRecommendationClaimed(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Recommendation>
DefaultRecommenderStub::MarkRecommendationSucceeded(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&
        request) {
  google::cloud::recommender::v1::Recommendation response;
  auto status =
      grpc_stub_->MarkRecommendationSucceeded(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::Recommendation>
DefaultRecommenderStub::MarkRecommendationFailed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
        request) {
  google::cloud::recommender::v1::Recommendation response;
  auto status =
      grpc_stub_->MarkRecommendationFailed(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
DefaultRecommenderStub::GetRecommenderConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetRecommenderConfigRequest const&
        request) {
  google::cloud::recommender::v1::RecommenderConfig response;
  auto status = grpc_stub_->GetRecommenderConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
DefaultRecommenderStub::UpdateRecommenderConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
        request) {
  google::cloud::recommender::v1::RecommenderConfig response;
  auto status =
      grpc_stub_->UpdateRecommenderConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
DefaultRecommenderStub::GetInsightTypeConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
        request) {
  google::cloud::recommender::v1::InsightTypeConfig response;
  auto status = grpc_stub_->GetInsightTypeConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
DefaultRecommenderStub::UpdateInsightTypeConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
        request) {
  google::cloud::recommender::v1::InsightTypeConfig response;
  auto status =
      grpc_stub_->UpdateInsightTypeConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender_v1_internal
}  // namespace cloud
}  // namespace google
