// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/serving_config_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_SERVING_CONFIG_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_SERVING_CONFIG_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/retail/v2/serving_config_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ServingConfigServiceStub {
 public:
  virtual ~ServingConfigServiceStub() = 0;

  virtual StatusOr<google::cloud::retail::v2::ServingConfig>
  CreateServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::CreateServingConfigRequest const& request) = 0;

  virtual Status DeleteServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::DeleteServingConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::ServingConfig>
  UpdateServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::UpdateServingConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::ServingConfig> GetServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::GetServingConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::ListServingConfigsResponse>
  ListServingConfigs(
      grpc::ClientContext& context,
      google::cloud::retail::v2::ListServingConfigsRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::ServingConfig> AddControl(
      grpc::ClientContext& context,
      google::cloud::retail::v2::AddControlRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::ServingConfig> RemoveControl(
      grpc::ClientContext& context,
      google::cloud::retail::v2::RemoveControlRequest const& request) = 0;
};

class DefaultServingConfigServiceStub : public ServingConfigServiceStub {
 public:
  explicit DefaultServingConfigServiceStub(
      std::unique_ptr<
          google::cloud::retail::v2::ServingConfigService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::retail::v2::ServingConfig> CreateServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::CreateServingConfigRequest const& request)
      override;

  Status DeleteServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::DeleteServingConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::ServingConfig> UpdateServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::UpdateServingConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::ServingConfig> GetServingConfig(
      grpc::ClientContext& context,
      google::cloud::retail::v2::GetServingConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::ListServingConfigsResponse>
  ListServingConfigs(grpc::ClientContext& context,
                     google::cloud::retail::v2::ListServingConfigsRequest const&
                         request) override;

  StatusOr<google::cloud::retail::v2::ServingConfig> AddControl(
      grpc::ClientContext& context,
      google::cloud::retail::v2::AddControlRequest const& request) override;

  StatusOr<google::cloud::retail::v2::ServingConfig> RemoveControl(
      grpc::ClientContext& context,
      google::cloud::retail::v2::RemoveControlRequest const& request) override;

 private:
  std::unique_ptr<
      google::cloud::retail::v2::ServingConfigService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_SERVING_CONFIG_STUB_H
