// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/v1/internal/registration_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegistrationServiceTracingConnection::RegistrationServiceTracingConnection(
    std::shared_ptr<servicedirectory_v1::RegistrationServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceTracingConnection::CreateNamespace(
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::CreateNamespace");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateNamespace(request));
}

StreamRange<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceTracingConnection::ListNamespaces(
    google::cloud::servicedirectory::v1::ListNamespacesRequest request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::ListNamespaces");
  internal::OTelScope scope(span);
  auto sr = child_->ListNamespaces(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicedirectory::v1::Namespace>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceTracingConnection::GetNamespace(
    google::cloud::servicedirectory::v1::GetNamespaceRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::GetNamespace");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNamespace(request));
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceTracingConnection::UpdateNamespace(
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::UpdateNamespace");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateNamespace(request));
}

Status RegistrationServiceTracingConnection::DeleteNamespace(
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::DeleteNamespace");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteNamespace(request));
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceTracingConnection::CreateService(
    google::cloud::servicedirectory::v1::CreateServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::CreateService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateService(request));
}

StreamRange<google::cloud::servicedirectory::v1::Service>
RegistrationServiceTracingConnection::ListServices(
    google::cloud::servicedirectory::v1::ListServicesRequest request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::ListServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicedirectory::v1::Service>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceTracingConnection::GetService(
    google::cloud::servicedirectory::v1::GetServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::GetService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetService(request));
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceTracingConnection::UpdateService(
    google::cloud::servicedirectory::v1::UpdateServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::UpdateService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateService(request));
}

Status RegistrationServiceTracingConnection::DeleteService(
    google::cloud::servicedirectory::v1::DeleteServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::DeleteService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteService(request));
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceTracingConnection::CreateEndpoint(
    google::cloud::servicedirectory::v1::CreateEndpointRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::CreateEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateEndpoint(request));
}

StreamRange<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceTracingConnection::ListEndpoints(
    google::cloud::servicedirectory::v1::ListEndpointsRequest request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::ListEndpoints");
  internal::OTelScope scope(span);
  auto sr = child_->ListEndpoints(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::servicedirectory::v1::Endpoint>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceTracingConnection::GetEndpoint(
    google::cloud::servicedirectory::v1::GetEndpointRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::GetEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEndpoint(request));
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceTracingConnection::UpdateEndpoint(
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::UpdateEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEndpoint(request));
}

Status RegistrationServiceTracingConnection::DeleteEndpoint(
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::DeleteEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteEndpoint(request));
}

StatusOr<google::iam::v1::Policy>
RegistrationServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
RegistrationServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
RegistrationServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "servicedirectory_v1::RegistrationServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<servicedirectory_v1::RegistrationServiceConnection>
MakeRegistrationServiceTracingConnection(
    std::shared_ptr<servicedirectory_v1::RegistrationServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<RegistrationServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1_internal
}  // namespace cloud
}  // namespace google
