// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_MOCKS_MOCK_ADAPTATION_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_MOCKS_MOCK_ADAPTATION_CONNECTION_H

#include "google/cloud/speech/v1/adaptation_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace speech_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `AdaptationConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `AdaptationClient`. To do so,
 * construct an object of type `AdaptationClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockAdaptationConnection : public speech_v1::AdaptationConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::speech::v1::PhraseSet>, CreatePhraseSet,
      (google::cloud::speech::v1::CreatePhraseSetRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::speech::v1::PhraseSet>, GetPhraseSet,
              (google::cloud::speech::v1::GetPhraseSetRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::speech::v1::PhraseSet>),
              ListPhraseSet,
              (google::cloud::speech::v1::ListPhraseSetRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::speech::v1::PhraseSet>, UpdatePhraseSet,
      (google::cloud::speech::v1::UpdatePhraseSetRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeletePhraseSet,
      (google::cloud::speech::v1::DeletePhraseSetRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::speech::v1::CustomClass>, CreateCustomClass,
      (google::cloud::speech::v1::CreateCustomClassRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::speech::v1::CustomClass>, GetCustomClass,
              (google::cloud::speech::v1::GetCustomClassRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::speech::v1::CustomClass>),
              ListCustomClasses,
              (google::cloud::speech::v1::ListCustomClassesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::speech::v1::CustomClass>, UpdateCustomClass,
      (google::cloud::speech::v1::UpdateCustomClassRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteCustomClass,
      (google::cloud::speech::v1::DeleteCustomClassRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_MOCKS_MOCK_ADAPTATION_CONNECTION_H
