// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_ssl_certs.proto

#include "google/cloud/sql/v1/internal/sql_ssl_certs_rest_stub.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/rest_stub_helpers.h"
#include "google/cloud/status_or.h"
#include <google/cloud/sql/v1/cloud_sql_ssl_certs.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace sql_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DefaultSqlSslCertsServiceRestStub::DefaultSqlSslCertsServiceRestStub(
    Options options)
    : service_(rest_internal::MakePooledRestClient(
          options.get<EndpointOption>(), options)),
      options_(std::move(options)) {}

DefaultSqlSslCertsServiceRestStub::DefaultSqlSslCertsServiceRestStub(
    std::shared_ptr<rest_internal::RestClient> service, Options options)
    : service_(std::move(service)), options_(std::move(options)) {}

StatusOr<google::cloud::sql::v1::Operation>
DefaultSqlSslCertsServiceRestStub::Delete(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::sql::v1::SqlSslCertsDeleteRequest const& request) {
  return rest_internal::Delete<google::cloud::sql::v1::Operation>(
      *service_, rest_context, request, true,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/",
                   "projects", "/", request.project(), "/", "instances", "/",
                   request.instance(), "/", "sslCerts", "/",
                   request.sha1_fingerprint()));
}

StatusOr<google::cloud::sql::v1::SslCert>
DefaultSqlSslCertsServiceRestStub::Get(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::sql::v1::SqlSslCertsGetRequest const& request) {
  return rest_internal::Get<google::cloud::sql::v1::SslCert>(
      *service_, rest_context, request, true,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/",
                   "projects", "/", request.project(), "/", "instances", "/",
                   request.instance(), "/", "sslCerts", "/",
                   request.sha1_fingerprint()));
}

StatusOr<google::cloud::sql::v1::SslCertsInsertResponse>
DefaultSqlSslCertsServiceRestStub::Insert(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::sql::v1::SqlSslCertsInsertRequest const& request) {
  return rest_internal::Post<google::cloud::sql::v1::SslCertsInsertResponse>(
      *service_, rest_context, request.body(), true,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/",
                   "projects", "/", request.project(), "/", "instances", "/",
                   request.instance(), "/", "sslCerts"));
}

StatusOr<google::cloud::sql::v1::SslCertsListResponse>
DefaultSqlSslCertsServiceRestStub::List(
    google::cloud::rest_internal::RestContext& rest_context,
    Options const& options,
    google::cloud::sql::v1::SqlSslCertsListRequest const& request) {
  return rest_internal::Get<google::cloud::sql::v1::SslCertsListResponse>(
      *service_, rest_context, request, true,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/",
                   "projects", "/", request.project(), "/", "instances", "/",
                   request.instance(), "/", "sslCerts"));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1_internal
}  // namespace cloud
}  // namespace google
