// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/v4/internal/company_auth_decorator.h"
#include <google/cloud/talent/v4/company_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompanyServiceAuth::CompanyServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<CompanyServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceAuth::CreateCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::CreateCompanyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateCompany(context, request);
}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceAuth::GetCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::GetCompanyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetCompany(context, request);
}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceAuth::UpdateCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::UpdateCompanyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateCompany(context, request);
}

Status CompanyServiceAuth::DeleteCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::DeleteCompanyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteCompany(context, request);
}

StatusOr<google::cloud::talent::v4::ListCompaniesResponse>
CompanyServiceAuth::ListCompanies(
    grpc::ClientContext& context,
    google::cloud::talent::v4::ListCompaniesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListCompanies(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
