// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v2/cloud_tpu.proto

#include "google/cloud/tpu/v2/internal/tpu_connection_impl.h"
#include "google/cloud/tpu/v2/internal/tpu_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace tpu_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<tpu_v2::TpuRetryPolicy> retry_policy(Options const& options) {
  return options.get<tpu_v2::TpuRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<tpu_v2::TpuBackoffPolicyOption>()->clone();
}

std::unique_ptr<tpu_v2::TpuConnectionIdempotencyPolicy> idempotency_policy(
    Options const& options) {
  return options.get<tpu_v2::TpuConnectionIdempotencyPolicyOption>()->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<tpu_v2::TpuPollingPolicyOption>()->clone();
}

}  // namespace

TpuConnectionImpl::TpuConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<tpu_v2_internal::TpuStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      TpuConnection::options())) {}

StreamRange<google::cloud::tpu::v2::Node> TpuConnectionImpl::ListNodes(
    google::cloud::tpu::v2::ListNodesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNodes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tpu::v2::Node>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<tpu_v2::TpuRetryPolicy>(retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::tpu::v2::ListNodesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::tpu::v2::ListNodesRequest const& request) {
              return stub->ListNodes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::tpu::v2::ListNodesResponse r) {
        std::vector<google::cloud::tpu::v2::Node> result(r.nodes().size());
        auto& messages = *r.mutable_nodes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::tpu::v2::Node> TpuConnectionImpl::GetNode(
    google::cloud::tpu::v2::GetNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNode(request),
      [this](grpc::ClientContext& context,
             google::cloud::tpu::v2::GetNodeRequest const& request) {
        return stub_->GetNode(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuConnectionImpl::CreateNode(
    google::cloud::tpu::v2::CreateNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::tpu::v2::Node>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::tpu::v2::CreateNodeRequest const& request) {
        return stub->AsyncCreateNode(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::tpu::v2::Node>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateNode(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::tpu::v2::OperationMetadata>>
TpuConnectionImpl::DeleteNode(
    google::cloud::tpu::v2::DeleteNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::tpu::v2::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::tpu::v2::DeleteNodeRequest const& request) {
        return stub->AsyncDeleteNode(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::tpu::v2::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteNode(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuConnectionImpl::StopNode(
    google::cloud::tpu::v2::StopNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::tpu::v2::Node>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::tpu::v2::StopNodeRequest const& request) {
        return stub->AsyncStopNode(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::tpu::v2::Node>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StopNode(request), polling_policy(*current),
      __func__);
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuConnectionImpl::StartNode(
    google::cloud::tpu::v2::StartNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::tpu::v2::Node>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::tpu::v2::StartNodeRequest const& request) {
        return stub->AsyncStartNode(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::tpu::v2::Node>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StartNode(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuConnectionImpl::UpdateNode(
    google::cloud::tpu::v2::UpdateNodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::tpu::v2::Node>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::tpu::v2::UpdateNodeRequest const& request) {
        return stub->AsyncUpdateNode(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::tpu::v2::Node>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNode(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::tpu::v2::GenerateServiceIdentityResponse>
TpuConnectionImpl::GenerateServiceIdentity(
    google::cloud::tpu::v2::GenerateServiceIdentityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateServiceIdentity(request),
      [this](grpc::ClientContext& context,
             google::cloud::tpu::v2::GenerateServiceIdentityRequest const&
                 request) {
        return stub_->GenerateServiceIdentity(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::tpu::v2::AcceleratorType>
TpuConnectionImpl::ListAcceleratorTypes(
    google::cloud::tpu::v2::ListAcceleratorTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAcceleratorTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tpu::v2::AcceleratorType>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<tpu_v2::TpuRetryPolicy>(retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::tpu::v2::ListAcceleratorTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::tpu::v2::ListAcceleratorTypesRequest const&
                       request) {
              return stub->ListAcceleratorTypes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::tpu::v2::ListAcceleratorTypesResponse r) {
        std::vector<google::cloud::tpu::v2::AcceleratorType> result(
            r.accelerator_types().size());
        auto& messages = *r.mutable_accelerator_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::tpu::v2::AcceleratorType>
TpuConnectionImpl::GetAcceleratorType(
    google::cloud::tpu::v2::GetAcceleratorTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAcceleratorType(request),
      [this](grpc::ClientContext& context,
             google::cloud::tpu::v2::GetAcceleratorTypeRequest const& request) {
        return stub_->GetAcceleratorType(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::tpu::v2::RuntimeVersion>
TpuConnectionImpl::ListRuntimeVersions(
    google::cloud::tpu::v2::ListRuntimeVersionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListRuntimeVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tpu::v2::RuntimeVersion>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<tpu_v2::TpuRetryPolicy>(retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::tpu::v2::ListRuntimeVersionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::tpu::v2::ListRuntimeVersionsRequest const&
                       request) {
              return stub->ListRuntimeVersions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::tpu::v2::ListRuntimeVersionsResponse r) {
        std::vector<google::cloud::tpu::v2::RuntimeVersion> result(
            r.runtime_versions().size());
        auto& messages = *r.mutable_runtime_versions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::tpu::v2::RuntimeVersion>
TpuConnectionImpl::GetRuntimeVersion(
    google::cloud::tpu::v2::GetRuntimeVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRuntimeVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::tpu::v2::GetRuntimeVersionRequest const& request) {
        return stub_->GetRuntimeVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tpu::v2::GetGuestAttributesResponse>
TpuConnectionImpl::GetGuestAttributes(
    google::cloud::tpu::v2::GetGuestAttributesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGuestAttributes(request),
      [this](grpc::ClientContext& context,
             google::cloud::tpu::v2::GetGuestAttributesRequest const& request) {
        return stub_->GetGuestAttributes(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v2_internal
}  // namespace cloud
}  // namespace google
