// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/workstations_connection.h"
#include "google/cloud/workstations/v1/internal/workstations_connection_impl.h"
#include "google/cloud/workstations/v1/internal/workstations_option_defaults.h"
#include "google/cloud/workstations/v1/internal/workstations_stub_factory.h"
#include "google/cloud/workstations/v1/internal/workstations_tracing_connection.h"
#include "google/cloud/workstations/v1/workstations_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WorkstationsConnection::~WorkstationsConnection() = default;

StatusOr<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsConnection::GetWorkstationCluster(
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsConnection::ListWorkstationClusters(
    google::cloud::workstations::v1::
        ListWorkstationClustersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationCluster>>();
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnection::CreateWorkstationCluster(
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnection::UpdateWorkstationCluster(
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnection::DeleteWorkstationCluster(
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationCluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnection::GetWorkstationConfig(
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnection::ListWorkstationConfigs(
    google::cloud::workstations::v1::
        ListWorkstationConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationConfig>>();
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnection::ListUsableWorkstationConfigs(
    google::cloud::workstations::v1::
        ListUsableWorkstationConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationConfig>>();
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnection::CreateWorkstationConfig(
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnection::UpdateWorkstationConfig(
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnection::DeleteWorkstationConfig(
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::WorkstationConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::workstations::v1::Workstation>
WorkstationsConnection::GetWorkstation(
    google::cloud::workstations::v1::GetWorkstationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsConnection::ListWorkstations(
    google::cloud::workstations::v1::
        ListWorkstationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::workstations::v1::Workstation>>();
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsConnection::ListUsableWorkstations(
    google::cloud::workstations::v1::
        ListUsableWorkstationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::workstations::v1::Workstation>>();
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnection::CreateWorkstation(
    google::cloud::workstations::v1::CreateWorkstationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::Workstation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnection::UpdateWorkstation(
    google::cloud::workstations::v1::UpdateWorkstationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::Workstation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnection::DeleteWorkstation(
    google::cloud::workstations::v1::DeleteWorkstationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::Workstation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnection::StartWorkstation(
    google::cloud::workstations::v1::StartWorkstationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::Workstation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnection::StopWorkstation(
    google::cloud::workstations::v1::StopWorkstationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workstations::v1::Workstation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
WorkstationsConnection::GenerateAccessToken(
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<WorkstationsConnection> MakeWorkstationsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 WorkstationsPolicyOptionList>(options,
                                                               __func__);
  options =
      workstations_v1_internal::WorkstationsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = workstations_v1_internal::CreateDefaultWorkstationsStub(
      background->cq(), options);
  return workstations_v1_internal::MakeWorkstationsTracingConnection(
      std::make_shared<workstations_v1_internal::WorkstationsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1
}  // namespace cloud
}  // namespace google
