// Code generated by zenity; DO NOT EDIT.

//go:build darwin

package zenutil

import (
	"encoding/json"
	"text/template"
)

var scripts = template.Must(template.New("").Funcs(template.FuncMap{"json": func(v any) (string, error) {
	b, err := json.Marshal(v)
	return string(b), err
}}).Parse(`
{{define "color" -}}
ObjC.import('stdio')
ObjC.import('stdlib')
{{template "common" .}}
try{var res=app.chooseColor({defaultColor:{{json .Color}}})}catch(e){if(e.errorNumber===-128)$.exit(1)
$.dprintf(2,e)
$.exit(-1)}
{'rgb('+res.map(x=>Math.round(x*255))+')'}
{{- end}}
{{define "common" -}}
{{if .WindowIcon}}{ObjC.import('Cocoa')
let nsapp=$.NSApplication.sharedApplication
let nsimg=$.NSImage.alloc.initWithContentsOfFile({{json .WindowIcon}})
nsapp.setActivationPolicy($.NSApplicationActivationPolicyRegular)
nsapp.setApplicationIconImage(nsimg)}{{end}}
{{- if .Application}}
try{var app=Application({{json .Application}})}catch{var app=Application.currentApplication()}
{{- else}}
var app=Application.currentApplication()
{{- end}}
app.includeStandardAdditions=true
app.activate()
{{- end}}
{{define "date" -}}
ObjC.import('Cocoa')
ObjC.import('stdio')
ObjC.import('stdlib')
var nsapp=$.NSApplication.sharedApplication
nsapp.setActivationPolicy($.NSApplicationActivationPolicyAccessory)
{{template "common" .}}
var date=$.NSDatePicker.alloc.init
date.setDatePickerStyle($.NSDatePickerStyleClockAndCalendar)
date.setDatePickerElements($.NSDatePickerElementFlagYearMonthDay)
date.setFrameSize(date.fittingSize)
{{- if .Date}}
date.setDateValue($.NSDate.dateWithTimeIntervalSince1970({{.Date}}))
{{- else}}
date.setDateValue($.NSDate.date)
{{- end}}
var alert=$.NSAlert.alloc.init
alert.setAccessoryView(date)
alert.setMessageText({{json .Text}})
alert.addButtonWithTitle({{json .OK}})
alert.addButtonWithTitle({{json .Cancel}}).keyEquivalent='\033'
{{- if .Info}}
alert.setInformativeText({{json .Info}})
{{- end}}
{{- if .Extra}}
alert.addButtonWithTitle({{json .Extra}})
{{- end}}
var res=alert.runModal
switch(res){case $.NSAlertThirdButtonReturn:$.puts({{json .Extra}})
case $.NSAlertSecondButtonReturn:$.exit(1)}
var fmt=$.NSDateFormatter.alloc.init
fmt.locale=$.NSLocale.localeWithLocaleIdentifier('en_US_POSIX')
fmt.dateFormat={{json .Format}}
fmt.stringFromDate(date.dateValue)
{{- end}}
{{define "dialog" -}}
ObjC.import('stdio')
ObjC.import('stdlib')
{{template "common" .}}
var opts={{json .Options}}
{{- if .IconPath}}
opts.withIcon=Path({{json .IconPath}})
{{- end}}
try{var res=app.{{.Operation}}({{json .Text}},opts)}catch(e){if(e.errorNumber===-128)$.exit(1)
$.dprintf(2,e)
$.exit(-1)}
if(res.gaveUp){$.exit(5)}
if(res.buttonReturned==={{json .Extra}}){$.puts({{json .Extra}})
$.exit(1)}
res.textReturned
{{- end}}
{{define "file" -}}
{{template "common" .}}
ObjC.import('stdio')
ObjC.import('stdlib')
try{var res=app.{{.Operation}}({{json .Options}})}catch(e){if(e.errorNumber===-128)$.exit(1)
$.dprintf(2,e)
$.exit(-1)}
if(Array.isArray(res)){res.join({{json .Separator}})}else{res.toString()}
{{- end}}
{{define "list" -}}
{{template "common" .}}
ObjC.import('stdio')
ObjC.import('stdlib')
try{var res=app.chooseFromList({{json .Items}},{{json .Options}})}catch(e){$.dprintf(2,e)
$.exit(-1)}
if(res===false)$.exit(1)
if(res.length!==0)res.join({{json .Separator}})
{{- end}}
{{define "notify" -}}
var app=Application.currentApplication()
app.includeStandardAdditions=true
void app.displayNotification({{json .Text}},{{json .Options}})
{{- end}}
{{define "progress" -}}
{{template "common" .}}
ObjC.import('stdlib')
ObjC.import('readline')
{{- if .Total}}
Progress.totalUnitCount={{.Total}}
{{- end}}
{{- if .Description}}
Progress.description={{json .Description}}
{{- end}}
while(true){try{var s=$.readline('')}catch(e){if(e.errorNumber===-128)$.exit(1)
break}
if(s.indexOf('#')===0){Progress.additionalDescription=s.slice(1)
continue}
var i=parseInt(s)
if(i>=0&&Progress.totalUnitCount>0){Progress.completedUnitCount=i}}
{{- end}}
{{define "pwd" -}}
{{template "common" .}}
ObjC.import('stdio')
ObjC.import('stdlib')
var opts={{json .Options}}
{{- if .IconPath}}
opts.withIcon=Path({{json .IconPath}})
{{- end}}
function dialog(text){try{var res=app.displayDialog(text,opts)}catch(e){if(e.errorNumber===-128)$.exit(1)
$.dprintf(2,e)
$.exit(-1)}
if(res.gaveUp){$.exit(5)}
if(res.buttonReturned==={{json .Extra}}){$.puts({{json .Extra}})
$.exit(1)}
return res.textReturned}
var start=Date.now()
opts.defaultAnswer=''
var username=dialog('Username:')
{{- if .Options.Timeout}}
opts.givingUpAfter-=(Date.now()-start)/1000|0
{{- end}}
opts.hiddenAnswer=true
var password=dialog('Password:')
username+{{json .Separator}}+password
{{- end}}`))
