// An index contains one or more pieces of information about a given piece of
// source code or software artifact. Complementary information can be merged
// together from multiple sources to provide a unified code intelligence
// experience.
//
// Programs producing a file of this format is an "indexer" and may operate
// somewhere on the spectrum between precision, such as indexes produced by
// compiler-backed indexers, and heurstics, such as indexes produced by local
// syntax-directed analysis for scope rules.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        (unknown)
// source: scip.proto

package scip

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ProtocolVersion int32

const (
	ProtocolVersion_UnspecifiedProtocolVersion ProtocolVersion = 0
)

// Enum value maps for ProtocolVersion.
var (
	ProtocolVersion_name = map[int32]string{
		0: "UnspecifiedProtocolVersion",
	}
	ProtocolVersion_value = map[string]int32{
		"UnspecifiedProtocolVersion": 0,
	}
)

func (x ProtocolVersion) Enum() *ProtocolVersion {
	p := new(ProtocolVersion)
	*p = x
	return p
}

func (x ProtocolVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProtocolVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[0].Descriptor()
}

func (ProtocolVersion) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[0]
}

func (x ProtocolVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProtocolVersion.Descriptor instead.
func (ProtocolVersion) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{0}
}

type TextEncoding int32

const (
	TextEncoding_UnspecifiedTextEncoding TextEncoding = 0
	TextEncoding_UTF8                    TextEncoding = 1
	TextEncoding_UTF16                   TextEncoding = 2
)

// Enum value maps for TextEncoding.
var (
	TextEncoding_name = map[int32]string{
		0: "UnspecifiedTextEncoding",
		1: "UTF8",
		2: "UTF16",
	}
	TextEncoding_value = map[string]int32{
		"UnspecifiedTextEncoding": 0,
		"UTF8":                    1,
		"UTF16":                   2,
	}
)

func (x TextEncoding) Enum() *TextEncoding {
	p := new(TextEncoding)
	*p = x
	return p
}

func (x TextEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TextEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[1].Descriptor()
}

func (TextEncoding) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[1]
}

func (x TextEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TextEncoding.Descriptor instead.
func (TextEncoding) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{1}
}

// SymbolRole declares what "role" a symbol has in an occurrence.  A role is
// encoded as a bitset where each bit represents a different role. For example,
// to determine if the `Import` role is set, test whether the second bit of the
// enum value is defined. In pseudocode, this can be implemented with the
// logic: `const isImportRole = (role.value & SymbolRole.Import.value) > 0`.
type SymbolRole int32

const (
	// This case is not meant to be used; it only exists to avoid an error
	// from the Protobuf code generator.
	SymbolRole_UnspecifiedSymbolRole SymbolRole = 0
	// Is the symbol defined here? If not, then this is a symbol reference.
	SymbolRole_Definition SymbolRole = 1
	// Is the symbol imported here?
	SymbolRole_Import SymbolRole = 2
	// Is the symbol written here?
	SymbolRole_WriteAccess SymbolRole = 4
	// Is the symbol read here?
	SymbolRole_ReadAccess SymbolRole = 8
	// Is the symbol in generated code?
	SymbolRole_Generated SymbolRole = 16
	// Is the symbol in test code?
	SymbolRole_Test SymbolRole = 32
)

// Enum value maps for SymbolRole.
var (
	SymbolRole_name = map[int32]string{
		0:  "UnspecifiedSymbolRole",
		1:  "Definition",
		2:  "Import",
		4:  "WriteAccess",
		8:  "ReadAccess",
		16: "Generated",
		32: "Test",
	}
	SymbolRole_value = map[string]int32{
		"UnspecifiedSymbolRole": 0,
		"Definition":            1,
		"Import":                2,
		"WriteAccess":           4,
		"ReadAccess":            8,
		"Generated":             16,
		"Test":                  32,
	}
)

func (x SymbolRole) Enum() *SymbolRole {
	p := new(SymbolRole)
	*p = x
	return p
}

func (x SymbolRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SymbolRole) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[2].Descriptor()
}

func (SymbolRole) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[2]
}

func (x SymbolRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SymbolRole.Descriptor instead.
func (SymbolRole) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{2}
}

type SyntaxKind int32

const (
	SyntaxKind_UnspecifiedSyntaxKind SyntaxKind = 0
	// Comment, including comment markers and text
	SyntaxKind_Comment SyntaxKind = 1
	// `;` `.` `,`
	SyntaxKind_PunctuationDelimiter SyntaxKind = 2
	// (), {}, [] when used syntactically
	SyntaxKind_PunctuationBracket SyntaxKind = 3
	// `if`, `else`, `return`, `class`, etc.
	SyntaxKind_Keyword SyntaxKind = 4
	// Deprecated: Do not use.
	SyntaxKind_IdentifierKeyword SyntaxKind = 4
	// `+`, `*`, etc.
	SyntaxKind_IdentifierOperator SyntaxKind = 5
	// non-specific catch-all for any identifier not better described elsewhere
	SyntaxKind_Identifier SyntaxKind = 6
	// Identifiers builtin to the language: `min`, `print` in Python.
	SyntaxKind_IdentifierBuiltin SyntaxKind = 7
	// Identifiers representing `null`-like values: `None` in Python, `nil` in Go.
	SyntaxKind_IdentifierNull SyntaxKind = 8
	// `xyz` in `const xyz = "hello"`
	SyntaxKind_IdentifierConstant SyntaxKind = 9
	// `var X = "hello"` in Go
	SyntaxKind_IdentifierMutableGlobal SyntaxKind = 10
	// Parameter definition and references
	SyntaxKind_IdentifierParameter SyntaxKind = 11
	// Identifiers for variable definitions and references within a local scope
	SyntaxKind_IdentifierLocal SyntaxKind = 12
	// Identifiers that shadow other identifiers in an outer scope
	SyntaxKind_IdentifierShadowed SyntaxKind = 13
	// Identifier representing a unit of code abstraction and/or namespacing.
	//
	// NOTE: This corresponds to a package in Go and JVM languages,
	// and a module in languages like Python and JavaScript.
	SyntaxKind_IdentifierNamespace SyntaxKind = 14
	// Deprecated: Do not use.
	SyntaxKind_IdentifierModule SyntaxKind = 14
	// Function references, including calls
	SyntaxKind_IdentifierFunction SyntaxKind = 15
	// Function definition only
	SyntaxKind_IdentifierFunctionDefinition SyntaxKind = 16
	// Macro references, including invocations
	SyntaxKind_IdentifierMacro SyntaxKind = 17
	// Macro definition only
	SyntaxKind_IdentifierMacroDefinition SyntaxKind = 18
	// non-builtin types
	SyntaxKind_IdentifierType SyntaxKind = 19
	// builtin types only, such as `str` for Python or `int` in Go
	SyntaxKind_IdentifierBuiltinType SyntaxKind = 20
	// Python decorators, c-like __attribute__
	SyntaxKind_IdentifierAttribute SyntaxKind = 21
	// `\b`
	SyntaxKind_RegexEscape SyntaxKind = 22
	// `*`, `+`
	SyntaxKind_RegexRepeated SyntaxKind = 23
	// `.`
	SyntaxKind_RegexWildcard SyntaxKind = 24
	// `(`, `)`, `[`, `]`
	SyntaxKind_RegexDelimiter SyntaxKind = 25
	// `|`, `-`
	SyntaxKind_RegexJoin SyntaxKind = 26
	// Literal strings: "Hello, world!"
	SyntaxKind_StringLiteral SyntaxKind = 27
	// non-regex escapes: "\t", "\n"
	SyntaxKind_StringLiteralEscape SyntaxKind = 28
	// datetimes within strings, special words within a string, `{}` in format strings
	SyntaxKind_StringLiteralSpecial SyntaxKind = 29
	// "key" in { "key": "value" }, useful for example in JSON
	SyntaxKind_StringLiteralKey SyntaxKind = 30
	// 'c' or similar, in languages that differentiate strings and characters
	SyntaxKind_CharacterLiteral SyntaxKind = 31
	// Literal numbers, both floats and integers
	SyntaxKind_NumericLiteral SyntaxKind = 32
	// `true`, `false`
	SyntaxKind_BooleanLiteral SyntaxKind = 33
	// Used for XML-like tags
	SyntaxKind_Tag SyntaxKind = 34
	// Attribute name in XML-like tags
	SyntaxKind_TagAttribute SyntaxKind = 35
	// Delimiters for XML-like tags
	SyntaxKind_TagDelimiter SyntaxKind = 36
)

// Enum value maps for SyntaxKind.
var (
	SyntaxKind_name = map[int32]string{
		0: "UnspecifiedSyntaxKind",
		1: "Comment",
		2: "PunctuationDelimiter",
		3: "PunctuationBracket",
		4: "Keyword",
		// Duplicate value: 4: "IdentifierKeyword",
		5:  "IdentifierOperator",
		6:  "Identifier",
		7:  "IdentifierBuiltin",
		8:  "IdentifierNull",
		9:  "IdentifierConstant",
		10: "IdentifierMutableGlobal",
		11: "IdentifierParameter",
		12: "IdentifierLocal",
		13: "IdentifierShadowed",
		14: "IdentifierNamespace",
		// Duplicate value: 14: "IdentifierModule",
		15: "IdentifierFunction",
		16: "IdentifierFunctionDefinition",
		17: "IdentifierMacro",
		18: "IdentifierMacroDefinition",
		19: "IdentifierType",
		20: "IdentifierBuiltinType",
		21: "IdentifierAttribute",
		22: "RegexEscape",
		23: "RegexRepeated",
		24: "RegexWildcard",
		25: "RegexDelimiter",
		26: "RegexJoin",
		27: "StringLiteral",
		28: "StringLiteralEscape",
		29: "StringLiteralSpecial",
		30: "StringLiteralKey",
		31: "CharacterLiteral",
		32: "NumericLiteral",
		33: "BooleanLiteral",
		34: "Tag",
		35: "TagAttribute",
		36: "TagDelimiter",
	}
	SyntaxKind_value = map[string]int32{
		"UnspecifiedSyntaxKind":        0,
		"Comment":                      1,
		"PunctuationDelimiter":         2,
		"PunctuationBracket":           3,
		"Keyword":                      4,
		"IdentifierKeyword":            4,
		"IdentifierOperator":           5,
		"Identifier":                   6,
		"IdentifierBuiltin":            7,
		"IdentifierNull":               8,
		"IdentifierConstant":           9,
		"IdentifierMutableGlobal":      10,
		"IdentifierParameter":          11,
		"IdentifierLocal":              12,
		"IdentifierShadowed":           13,
		"IdentifierNamespace":          14,
		"IdentifierModule":             14,
		"IdentifierFunction":           15,
		"IdentifierFunctionDefinition": 16,
		"IdentifierMacro":              17,
		"IdentifierMacroDefinition":    18,
		"IdentifierType":               19,
		"IdentifierBuiltinType":        20,
		"IdentifierAttribute":          21,
		"RegexEscape":                  22,
		"RegexRepeated":                23,
		"RegexWildcard":                24,
		"RegexDelimiter":               25,
		"RegexJoin":                    26,
		"StringLiteral":                27,
		"StringLiteralEscape":          28,
		"StringLiteralSpecial":         29,
		"StringLiteralKey":             30,
		"CharacterLiteral":             31,
		"NumericLiteral":               32,
		"BooleanLiteral":               33,
		"Tag":                          34,
		"TagAttribute":                 35,
		"TagDelimiter":                 36,
	}
)

func (x SyntaxKind) Enum() *SyntaxKind {
	p := new(SyntaxKind)
	*p = x
	return p
}

func (x SyntaxKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SyntaxKind) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[3].Descriptor()
}

func (SyntaxKind) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[3]
}

func (x SyntaxKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SyntaxKind.Descriptor instead.
func (SyntaxKind) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{3}
}

type Severity int32

const (
	Severity_UnspecifiedSeverity Severity = 0
	Severity_Error               Severity = 1
	Severity_Warning             Severity = 2
	Severity_Information         Severity = 3
	Severity_Hint                Severity = 4
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "UnspecifiedSeverity",
		1: "Error",
		2: "Warning",
		3: "Information",
		4: "Hint",
	}
	Severity_value = map[string]int32{
		"UnspecifiedSeverity": 0,
		"Error":               1,
		"Warning":             2,
		"Information":         3,
		"Hint":                4,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[4].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[4]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Severity.Descriptor instead.
func (Severity) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{4}
}

type DiagnosticTag int32

const (
	DiagnosticTag_UnspecifiedDiagnosticTag DiagnosticTag = 0
	DiagnosticTag_Unnecessary              DiagnosticTag = 1
	DiagnosticTag_Deprecated               DiagnosticTag = 2
)

// Enum value maps for DiagnosticTag.
var (
	DiagnosticTag_name = map[int32]string{
		0: "UnspecifiedDiagnosticTag",
		1: "Unnecessary",
		2: "Deprecated",
	}
	DiagnosticTag_value = map[string]int32{
		"UnspecifiedDiagnosticTag": 0,
		"Unnecessary":              1,
		"Deprecated":               2,
	}
)

func (x DiagnosticTag) Enum() *DiagnosticTag {
	p := new(DiagnosticTag)
	*p = x
	return p
}

func (x DiagnosticTag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiagnosticTag) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[5].Descriptor()
}

func (DiagnosticTag) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[5]
}

func (x DiagnosticTag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiagnosticTag.Descriptor instead.
func (DiagnosticTag) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{5}
}

// Language standardises names of common programming languages that can be used
// for the `Document.language` field. The primary purpose of this enum is to
// prevent a situation where we have a single programming language ends up with
// multiple string representations. For example, the C++ language uses the name
// "CPlusPlus" in this enum and other names such as "cpp" are incompatible.
// Feel free to send a pull-request to add missing programming languages.
type Language int32

const (
	Language_UnspecifiedLanguage Language = 0
	Language_ABAP                Language = 60
	Language_APL                 Language = 49
	Language_Ada                 Language = 39
	Language_Agda                Language = 45
	Language_AsciiDoc            Language = 86
	Language_Assembly            Language = 58
	Language_Awk                 Language = 66
	Language_Bat                 Language = 68
	Language_BibTeX              Language = 81
	Language_C                   Language = 34
	Language_COBOL               Language = 59
	Language_CPP                 Language = 35 // C++ (the name "CPP" was chosen for consistency with LSP)
	Language_CSS                 Language = 26
	Language_CSharp              Language = 1
	Language_Clojure             Language = 8
	Language_Coffeescript        Language = 21
	Language_CommonLisp          Language = 9
	Language_Coq                 Language = 47
	Language_Dart                Language = 3
	Language_Delphi              Language = 57
	Language_Diff                Language = 88
	Language_Dockerfile          Language = 80
	Language_Dyalog              Language = 50
	Language_Elixir              Language = 17
	Language_Erlang              Language = 18
	Language_FSharp              Language = 42
	Language_Fish                Language = 65
	Language_Flow                Language = 24
	Language_Fortran             Language = 56
	Language_Git_Commit          Language = 91
	Language_Git_Config          Language = 89
	Language_Git_Rebase          Language = 92
	Language_Go                  Language = 33
	Language_Groovy              Language = 7
	Language_HTML                Language = 30
	Language_Hack                Language = 20
	Language_Handlebars          Language = 90
	Language_Haskell             Language = 44
	Language_Idris               Language = 46
	Language_Ini                 Language = 72
	Language_J                   Language = 51
	Language_JSON                Language = 75
	Language_Java                Language = 6
	Language_JavaScript          Language = 22
	Language_JavaScriptReact     Language = 93
	Language_Jsonnet             Language = 76
	Language_Julia               Language = 55
	Language_Kotlin              Language = 4
	Language_LaTeX               Language = 83
	Language_Lean                Language = 48
	Language_Less                Language = 27
	Language_Lua                 Language = 12
	Language_Makefile            Language = 79
	Language_Markdown            Language = 84
	Language_Matlab              Language = 52
	Language_Nix                 Language = 77
	Language_OCaml               Language = 41
	Language_Objective_C         Language = 36
	Language_Objective_CPP       Language = 37
	Language_PHP                 Language = 19
	Language_PLSQL               Language = 70
	Language_Perl                Language = 13
	Language_PowerShell          Language = 67
	Language_Prolog              Language = 71
	Language_Python              Language = 15
	Language_R                   Language = 54
	Language_Racket              Language = 11
	Language_Raku                Language = 14
	Language_Razor               Language = 62
	Language_ReST                Language = 85
	Language_Ruby                Language = 16
	Language_Rust                Language = 40
	Language_SAS                 Language = 61
	Language_SCSS                Language = 29
	Language_SML                 Language = 43
	Language_SQL                 Language = 69
	Language_Sass                Language = 28
	Language_Scala               Language = 5
	Language_Scheme              Language = 10
	Language_ShellScript         Language = 64 // Bash
	Language_Skylark             Language = 78
	Language_Swift               Language = 2
	Language_TOML                Language = 73
	Language_TeX                 Language = 82
	Language_TypeScript          Language = 23
	Language_TypeScriptReact     Language = 94
	Language_VisualBasic         Language = 63
	Language_Vue                 Language = 25
	Language_Wolfram             Language = 53
	Language_XML                 Language = 31
	Language_XSL                 Language = 32
	Language_YAML                Language = 74
	Language_Zig                 Language = 38
)

// Enum value maps for Language.
var (
	Language_name = map[int32]string{
		0:  "UnspecifiedLanguage",
		60: "ABAP",
		49: "APL",
		39: "Ada",
		45: "Agda",
		86: "AsciiDoc",
		58: "Assembly",
		66: "Awk",
		68: "Bat",
		81: "BibTeX",
		34: "C",
		59: "COBOL",
		35: "CPP",
		26: "CSS",
		1:  "CSharp",
		8:  "Clojure",
		21: "Coffeescript",
		9:  "CommonLisp",
		47: "Coq",
		3:  "Dart",
		57: "Delphi",
		88: "Diff",
		80: "Dockerfile",
		50: "Dyalog",
		17: "Elixir",
		18: "Erlang",
		42: "FSharp",
		65: "Fish",
		24: "Flow",
		56: "Fortran",
		91: "Git_Commit",
		89: "Git_Config",
		92: "Git_Rebase",
		33: "Go",
		7:  "Groovy",
		30: "HTML",
		20: "Hack",
		90: "Handlebars",
		44: "Haskell",
		46: "Idris",
		72: "Ini",
		51: "J",
		75: "JSON",
		6:  "Java",
		22: "JavaScript",
		93: "JavaScriptReact",
		76: "Jsonnet",
		55: "Julia",
		4:  "Kotlin",
		83: "LaTeX",
		48: "Lean",
		27: "Less",
		12: "Lua",
		79: "Makefile",
		84: "Markdown",
		52: "Matlab",
		77: "Nix",
		41: "OCaml",
		36: "Objective_C",
		37: "Objective_CPP",
		19: "PHP",
		70: "PLSQL",
		13: "Perl",
		67: "PowerShell",
		71: "Prolog",
		15: "Python",
		54: "R",
		11: "Racket",
		14: "Raku",
		62: "Razor",
		85: "ReST",
		16: "Ruby",
		40: "Rust",
		61: "SAS",
		29: "SCSS",
		43: "SML",
		69: "SQL",
		28: "Sass",
		5:  "Scala",
		10: "Scheme",
		64: "ShellScript",
		78: "Skylark",
		2:  "Swift",
		73: "TOML",
		82: "TeX",
		23: "TypeScript",
		94: "TypeScriptReact",
		63: "VisualBasic",
		25: "Vue",
		53: "Wolfram",
		31: "XML",
		32: "XSL",
		74: "YAML",
		38: "Zig",
	}
	Language_value = map[string]int32{
		"UnspecifiedLanguage": 0,
		"ABAP":                60,
		"APL":                 49,
		"Ada":                 39,
		"Agda":                45,
		"AsciiDoc":            86,
		"Assembly":            58,
		"Awk":                 66,
		"Bat":                 68,
		"BibTeX":              81,
		"C":                   34,
		"COBOL":               59,
		"CPP":                 35,
		"CSS":                 26,
		"CSharp":              1,
		"Clojure":             8,
		"Coffeescript":        21,
		"CommonLisp":          9,
		"Coq":                 47,
		"Dart":                3,
		"Delphi":              57,
		"Diff":                88,
		"Dockerfile":          80,
		"Dyalog":              50,
		"Elixir":              17,
		"Erlang":              18,
		"FSharp":              42,
		"Fish":                65,
		"Flow":                24,
		"Fortran":             56,
		"Git_Commit":          91,
		"Git_Config":          89,
		"Git_Rebase":          92,
		"Go":                  33,
		"Groovy":              7,
		"HTML":                30,
		"Hack":                20,
		"Handlebars":          90,
		"Haskell":             44,
		"Idris":               46,
		"Ini":                 72,
		"J":                   51,
		"JSON":                75,
		"Java":                6,
		"JavaScript":          22,
		"JavaScriptReact":     93,
		"Jsonnet":             76,
		"Julia":               55,
		"Kotlin":              4,
		"LaTeX":               83,
		"Lean":                48,
		"Less":                27,
		"Lua":                 12,
		"Makefile":            79,
		"Markdown":            84,
		"Matlab":              52,
		"Nix":                 77,
		"OCaml":               41,
		"Objective_C":         36,
		"Objective_CPP":       37,
		"PHP":                 19,
		"PLSQL":               70,
		"Perl":                13,
		"PowerShell":          67,
		"Prolog":              71,
		"Python":              15,
		"R":                   54,
		"Racket":              11,
		"Raku":                14,
		"Razor":               62,
		"ReST":                85,
		"Ruby":                16,
		"Rust":                40,
		"SAS":                 61,
		"SCSS":                29,
		"SML":                 43,
		"SQL":                 69,
		"Sass":                28,
		"Scala":               5,
		"Scheme":              10,
		"ShellScript":         64,
		"Skylark":             78,
		"Swift":               2,
		"TOML":                73,
		"TeX":                 82,
		"TypeScript":          23,
		"TypeScriptReact":     94,
		"VisualBasic":         63,
		"Vue":                 25,
		"Wolfram":             53,
		"XML":                 31,
		"XSL":                 32,
		"YAML":                74,
		"Zig":                 38,
	}
)

func (x Language) Enum() *Language {
	p := new(Language)
	*p = x
	return p
}

func (x Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Language) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[6].Descriptor()
}

func (Language) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[6]
}

func (x Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Language.Descriptor instead.
func (Language) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{6}
}

type Descriptor_Suffix int32

const (
	Descriptor_UnspecifiedSuffix Descriptor_Suffix = 0
	// Unit of code abstraction and/or namespacing.
	//
	// NOTE: This corresponds to a package in Go and JVM languages.
	Descriptor_Namespace Descriptor_Suffix = 1
	// Use Namespace instead.
	//
	// Deprecated: Do not use.
	Descriptor_Package       Descriptor_Suffix = 1
	Descriptor_Type          Descriptor_Suffix = 2
	Descriptor_Term          Descriptor_Suffix = 3
	Descriptor_Method        Descriptor_Suffix = 4
	Descriptor_TypeParameter Descriptor_Suffix = 5
	Descriptor_Parameter     Descriptor_Suffix = 6
	Descriptor_Macro         Descriptor_Suffix = 9
	// Can be used for any purpose.
	Descriptor_Meta  Descriptor_Suffix = 7
	Descriptor_Local Descriptor_Suffix = 8
)

// Enum value maps for Descriptor_Suffix.
var (
	Descriptor_Suffix_name = map[int32]string{
		0: "UnspecifiedSuffix",
		1: "Namespace",
		// Duplicate value: 1: "Package",
		2: "Type",
		3: "Term",
		4: "Method",
		5: "TypeParameter",
		6: "Parameter",
		9: "Macro",
		7: "Meta",
		8: "Local",
	}
	Descriptor_Suffix_value = map[string]int32{
		"UnspecifiedSuffix": 0,
		"Namespace":         1,
		"Package":           1,
		"Type":              2,
		"Term":              3,
		"Method":            4,
		"TypeParameter":     5,
		"Parameter":         6,
		"Macro":             9,
		"Meta":              7,
		"Local":             8,
	}
)

func (x Descriptor_Suffix) Enum() *Descriptor_Suffix {
	p := new(Descriptor_Suffix)
	*p = x
	return p
}

func (x Descriptor_Suffix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Descriptor_Suffix) Descriptor() protoreflect.EnumDescriptor {
	return file_scip_proto_enumTypes[7].Descriptor()
}

func (Descriptor_Suffix) Type() protoreflect.EnumType {
	return &file_scip_proto_enumTypes[7]
}

func (x Descriptor_Suffix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Descriptor_Suffix.Descriptor instead.
func (Descriptor_Suffix) EnumDescriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{6, 0}
}

// Index represents a complete SCIP index for a workspace this is rooted at a
// single directory. An Index message payload can have a large memory footprint
// and it's therefore recommended to emit and consume an Index payload one field
// value at a time. To permit streaming consumption of an Index payload, the
// `metadata` field must appear at the start of the stream and must only appear
// once in the stream. Other field values may appear in any order.
type Index struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata about this index.
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Documents that belong to this index.
	Documents []*Document `protobuf:"bytes,2,rep,name=documents,proto3" json:"documents,omitempty"`
	// (optional) Symbols that are referenced from this index but are defined in
	// an external package (a separate `Index` message). Leave this field empty
	// if you assume the external package will get indexed separately. If the
	// external package won't get indexed for some reason then you can use this
	// field to provide hover documentation for those external symbols.
	ExternalSymbols []*SymbolInformation `protobuf:"bytes,3,rep,name=external_symbols,json=externalSymbols,proto3" json:"external_symbols,omitempty"`
}

func (x *Index) Reset() {
	*x = Index{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index) ProtoMessage() {}

func (x *Index) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index.ProtoReflect.Descriptor instead.
func (*Index) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{0}
}

func (x *Index) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Index) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *Index) GetExternalSymbols() []*SymbolInformation {
	if x != nil {
		return x.ExternalSymbols
	}
	return nil
}

type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which version of this protocol was used to generate this index?
	Version ProtocolVersion `protobuf:"varint,1,opt,name=version,proto3,enum=scip.ProtocolVersion" json:"version,omitempty"`
	// Information about the tool that produced this index.
	ToolInfo *ToolInfo `protobuf:"bytes,2,opt,name=tool_info,json=toolInfo,proto3" json:"tool_info,omitempty"`
	// URI-encoded absolute path to the root directory of this index. All
	// documents in this index must appear in a subdirectory of this root
	// directory.
	ProjectRoot string `protobuf:"bytes,3,opt,name=project_root,json=projectRoot,proto3" json:"project_root,omitempty"`
	// Text encoding of the source files on disk that are referenced from
	// `Document.relative_path`.
	TextDocumentEncoding TextEncoding `protobuf:"varint,4,opt,name=text_document_encoding,json=textDocumentEncoding,proto3,enum=scip.TextEncoding" json:"text_document_encoding,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{1}
}

func (x *Metadata) GetVersion() ProtocolVersion {
	if x != nil {
		return x.Version
	}
	return ProtocolVersion_UnspecifiedProtocolVersion
}

func (x *Metadata) GetToolInfo() *ToolInfo {
	if x != nil {
		return x.ToolInfo
	}
	return nil
}

func (x *Metadata) GetProjectRoot() string {
	if x != nil {
		return x.ProjectRoot
	}
	return ""
}

func (x *Metadata) GetTextDocumentEncoding() TextEncoding {
	if x != nil {
		return x.TextDocumentEncoding
	}
	return TextEncoding_UnspecifiedTextEncoding
}

type ToolInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the indexer that produced this index.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the indexer that produced this index.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Command-line arguments that were used to invoke this indexer.
	Arguments []string `protobuf:"bytes,3,rep,name=arguments,proto3" json:"arguments,omitempty"`
}

func (x *ToolInfo) Reset() {
	*x = ToolInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolInfo) ProtoMessage() {}

func (x *ToolInfo) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolInfo.ProtoReflect.Descriptor instead.
func (*ToolInfo) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{2}
}

func (x *ToolInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ToolInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ToolInfo) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

// Document defines the metadata about a source file on disk.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The string ID for the programming language this file is written in.
	// The `Language` enum contains the names of most common programming languages.
	// This field is typed as a string to permit any programming langauge, including
	// ones that are not specified by the `Language` enum.
	Language string `protobuf:"bytes,4,opt,name=language,proto3" json:"language,omitempty"`
	// (Required) Unique path to the text document.
	//
	// 1. The path must be relative to the directory supplied in the associated
	//    `Metadata.project_root`.
	// 2. The path must not begin with a leading '/'.
	// 3. The path must point to a regular file, not a symbolic link.
	// 4. The path must use '/' as the separator, including on Windows.
	// 5. The path must be canonical; it cannot include empty components ('//'),
	//    or '.' or '..'.
	RelativePath string `protobuf:"bytes,1,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// Occurrences that appear in this file.
	Occurrences []*Occurrence `protobuf:"bytes,2,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// Symbols that are "defined" within this document.
	//
	// This should include symbols which technically do not have any definition,
	// but have a reference and are defined by some other symbol (see
	// Relationship.is_definition).
	Symbols []*SymbolInformation `protobuf:"bytes,3,rep,name=symbols,proto3" json:"symbols,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{3}
}

func (x *Document) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *Document) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *Document) GetOccurrences() []*Occurrence {
	if x != nil {
		return x.Occurrences
	}
	return nil
}

func (x *Document) GetSymbols() []*SymbolInformation {
	if x != nil {
		return x.Symbols
	}
	return nil
}

// Symbol is similar to a URI, it identifies a class, method, or a local
// variable. `SymbolInformation` contains rich metadata about symbols such as
// the docstring.
//
// Symbol has a standardized string representation, which can be used
// interchangeably with `Symbol`. The syntax for Symbol is the following:
// ```
// # (<x>)+ stands for one or more repetitions of <x>
// <symbol>               ::= <scheme> ' ' <package> ' ' (<descriptor>)+ | 'local ' <local-id>
// <package>              ::= <manager> ' ' <package-name> ' ' <version>
// <scheme>               ::= any UTF-8, escape spaces with double space.
// <manager>              ::= same as above, use the placeholder '.' to indicate an empty value
// <package-name>         ::= same as above
// <version>              ::= same as above
// <descriptor>           ::= <namespace> | <type> | <term> | <method> | <type-parameter> | <parameter> | <meta>
// <namespace>            ::= <name> '/'
// <type>                 ::= <name> '#'
// <term>                 ::= <name> '.'
// <meta>                 ::= <name> ':'
// <method>               ::= <name> '(' <method-disambiguator> ').'
// <type-parameter>       ::= '[' <name> ']'
// <parameter>            ::= '(' <name> ')'
// <name>                 ::= <identifier>
// <method-disambiguator> ::= <simple-identifier>
// <identifier>           ::= <simple-identifier> | <escaped-identifier>
// <simple-identifier>    ::= (<identifier-character>)+
// <identifier-character> ::= '_' | '+' | '-' | '$' | ASCII letter or digit
// <escaped-identifier>   ::= '`' (<escaped-character>)+ '`'
// <escaped-characters>   ::= any UTF-8 character, escape backticks with double backtick.
// ```
//
// The list of descriptors for a symbol should together form a fully
// qualified name for the symbol. That is, it should serve as a unique
// identifier across the package. Typically, it will include one descriptor
// for every node in the AST (along the ancestry path) between the root of
// the file and the node corresponding to the symbol.
type Symbol struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Scheme      string        `protobuf:"bytes,1,opt,name=scheme,proto3" json:"scheme,omitempty"`
	Package     *Package      `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	Descriptors []*Descriptor `protobuf:"bytes,3,rep,name=descriptors,proto3" json:"descriptors,omitempty"`
}

func (x *Symbol) Reset() {
	*x = Symbol{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Symbol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Symbol) ProtoMessage() {}

func (x *Symbol) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Symbol.ProtoReflect.Descriptor instead.
func (*Symbol) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{4}
}

func (x *Symbol) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *Symbol) GetPackage() *Package {
	if x != nil {
		return x.Package
	}
	return nil
}

func (x *Symbol) GetDescriptors() []*Descriptor {
	if x != nil {
		return x.Descriptors
	}
	return nil
}

// Unit of packaging and distribution.
//
// NOTE: This corresponds to a module in Go and JVM languages.
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Manager string `protobuf:"bytes,1,opt,name=manager,proto3" json:"manager,omitempty"`
	Name    string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{5}
}

func (x *Package) GetManager() string {
	if x != nil {
		return x.Manager
	}
	return ""
}

func (x *Package) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Package) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type Descriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name          string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Disambiguator string            `protobuf:"bytes,2,opt,name=disambiguator,proto3" json:"disambiguator,omitempty"`
	Suffix        Descriptor_Suffix `protobuf:"varint,3,opt,name=suffix,proto3,enum=scip.Descriptor_Suffix" json:"suffix,omitempty"`
}

func (x *Descriptor) Reset() {
	*x = Descriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Descriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Descriptor) ProtoMessage() {}

func (x *Descriptor) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Descriptor.ProtoReflect.Descriptor instead.
func (*Descriptor) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{6}
}

func (x *Descriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Descriptor) GetDisambiguator() string {
	if x != nil {
		return x.Disambiguator
	}
	return ""
}

func (x *Descriptor) GetSuffix() Descriptor_Suffix {
	if x != nil {
		return x.Suffix
	}
	return Descriptor_UnspecifiedSuffix
}

// SymbolInformation defines metadata about a symbol, such as the symbol's
// docstring or what package it's defined it.
type SymbolInformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of this symbol, which can be referenced from `Occurence.symbol`.
	// The string must be formatted according to the grammar in `Symbol`.
	Symbol string `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	// (optional, but strongly recommended) The markdown-formatted documentation
	// for this symbol. This field is repeated to allow different kinds of
	// documentation.  For example, it's nice to include both the signature of a
	// method (parameters and return type) along with the accompanying docstring.
	Documentation []string `protobuf:"bytes,3,rep,name=documentation,proto3" json:"documentation,omitempty"`
	// (optional) Relationships to other symbols (e.g., implements, type definition).
	Relationships []*Relationship `protobuf:"bytes,4,rep,name=relationships,proto3" json:"relationships,omitempty"`
}

func (x *SymbolInformation) Reset() {
	*x = SymbolInformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SymbolInformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SymbolInformation) ProtoMessage() {}

func (x *SymbolInformation) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SymbolInformation.ProtoReflect.Descriptor instead.
func (*SymbolInformation) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{7}
}

func (x *SymbolInformation) GetSymbol() string {
	if x != nil {
		return x.Symbol
	}
	return ""
}

func (x *SymbolInformation) GetDocumentation() []string {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *SymbolInformation) GetRelationships() []*Relationship {
	if x != nil {
		return x.Relationships
	}
	return nil
}

type Relationship struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Symbol string `protobuf:"bytes,1,opt,name=symbol,proto3" json:"symbol,omitempty"`
	// When resolving "Find references", this field documents what other symbols
	// should be included together with this symbol. For example, consider the
	// following TypeScript code that defines two symbols `Animal#sound()` and
	// `Dog#sound()`:
	// ```ts
	// interface Animal {
	//           ^^^^^^ definition Animal#
	//   sound(): string
	//   ^^^^^ definition Animal#sound()
	// }
	// class Dog implements Animal {
	//       ^^^ definition Dog#, implementation_symbols = Animal#
	//   public sound(): string { return "woof" }
	//          ^^^^^ definition Dog#sound(), references_symbols = Animal#sound(), implementation_symbols = Animal#sound()
	// }
	// const animal: Animal = new Dog()
	//               ^^^^^^ reference Animal#
	// console.log(animal.sound())
	//                    ^^^^^ reference Animal#sound()
	// ```
	// Doing "Find references" on the symbol `Animal#sound()` should return
	// references to the `Dog#sound()` method as well. Vice-versa, doing "Find
	// references" on the `Dog#sound()` method should include references to the
	// `Animal#sound()` method as well.
	IsReference bool `protobuf:"varint,2,opt,name=is_reference,json=isReference,proto3" json:"is_reference,omitempty"`
	// Similar to `references_symbols` but for "Go to implementation".
	// It's common for the `implementation_symbols` and `references_symbols` fields
	// have the same values but that's not always the case.
	// In the TypeScript example above, observe that `implementation_symbols` has
	// the value `"Animal#"` for the "Dog#" symbol while `references_symbols` is
	// empty. When requesting "Find references" on the "Animal#" symbol we don't
	// want to include references to "Dog#" even if "Go to implementation" on the
	// "Animal#" symbol should navigate to the "Dog#" symbol.
	IsImplementation bool `protobuf:"varint,3,opt,name=is_implementation,json=isImplementation,proto3" json:"is_implementation,omitempty"`
	// Similar to `references_symbols` but for "Go to type definition".
	IsTypeDefinition bool `protobuf:"varint,4,opt,name=is_type_definition,json=isTypeDefinition,proto3" json:"is_type_definition,omitempty"`
	// Allows overriding the behavior of "Go to definition" and "Find references"
	// for symbols which do not have a definition of their own or could
	// potentially have multiple definitions.
	//
	// For example, in a language with single inheritance and no field overriding,
	// inherited fields can reuse the same symbol as the ancestor which declares
	// the field. In such a situation, is_definition is not needed.
	//
	// On the other hand, in languages with single inheritance and some form
	// of mixins, you can use is_definition to relate the symbol to the
	// matching symbol in ancestor classes, and is_reference to relate the
	// symbol to the matching symbol in mixins.
	//
	// NOTE: At the moment, due to limitations of the SCIP to LSIF conversion,
	// only global symbols in an index are allowed to use is_definition.
	// The relationship may not get recorded if either symbol is local.
	IsDefinition bool `protobuf:"varint,5,opt,name=is_definition,json=isDefinition,proto3" json:"is_definition,omitempty"` // Update registerInverseRelationships on adding a new field here.
}

func (x *Relationship) Reset() {
	*x = Relationship{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Relationship) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Relationship) ProtoMessage() {}

func (x *Relationship) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Relationship.ProtoReflect.Descriptor instead.
func (*Relationship) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{8}
}

func (x *Relationship) GetSymbol() string {
	if x != nil {
		return x.Symbol
	}
	return ""
}

func (x *Relationship) GetIsReference() bool {
	if x != nil {
		return x.IsReference
	}
	return false
}

func (x *Relationship) GetIsImplementation() bool {
	if x != nil {
		return x.IsImplementation
	}
	return false
}

func (x *Relationship) GetIsTypeDefinition() bool {
	if x != nil {
		return x.IsTypeDefinition
	}
	return false
}

func (x *Relationship) GetIsDefinition() bool {
	if x != nil {
		return x.IsDefinition
	}
	return false
}

// Occurrence associates a source position with a symbol and/or highlighting
// information.
//
// If possible, indexers should try to bundle logically related information
// across occurrences into a single occurrence to reduce payload sizes.
type Occurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source position of this occurrence. Must be exactly three or four
	// elements:
	//
	// - Four elements: `[startLine, startCharacter, endLine, endCharacter]`
	// - Three elements: `[startLine, startCharacter, endCharacter]`. The end line
	//   is inferred to have the same value as the start line.
	//
	// Line numbers and characters are always 0-based. Make sure to increment the
	// line/character values before displaying them in an editor-like UI because
	// editors conventionally use 1-based numbers.
	//
	// Historical note: the original draft of this schema had a `Range` message
	// type with `start` and `end` fields of type `Position`, mirroring LSP.
	// Benchmarks revealed that this encoding was inefficient and that we could
	// reduce the total payload size of an index by 50% by using `repeated int32`
	// instead.  The `repeated int32` encoding is admittedly more embarrassing to
	// work with in some programming languages but we hope the performance
	// improvements make up for it.
	Range []int32 `protobuf:"varint,1,rep,packed,name=range,proto3" json:"range,omitempty"`
	// (optional) The symbol that appears at this position. See
	// `SymbolInformation.symbol` for how to format symbols as strings.
	Symbol string `protobuf:"bytes,2,opt,name=symbol,proto3" json:"symbol,omitempty"`
	// (optional) Bitset containing `SymbolRole`s in this occurrence.
	// See `SymbolRole`'s documentation for how to read and write this field.
	SymbolRoles int32 `protobuf:"varint,3,opt,name=symbol_roles,json=symbolRoles,proto3" json:"symbol_roles,omitempty"`
	// (optional) CommonMark-formatted documentation for this specific range. If
	// empty, the `Symbol.documentation` field is used instead. One example
	// where this field might be useful is when the symbol represents a generic
	// function (with abstract type parameters such as `List<T>`) and at this
	// occurrence we know the exact values (such as `List<String>`).
	//
	// This field can also be used for dynamically or gradually typed languages,
	// which commonly allow for type-changing assignment.
	OverrideDocumentation []string `protobuf:"bytes,4,rep,name=override_documentation,json=overrideDocumentation,proto3" json:"override_documentation,omitempty"`
	// (optional) What syntax highlighting class should be used for this range?
	SyntaxKind SyntaxKind `protobuf:"varint,5,opt,name=syntax_kind,json=syntaxKind,proto3,enum=scip.SyntaxKind" json:"syntax_kind,omitempty"`
	// (optional) Diagnostics that have been reported for this specific range.
	Diagnostics []*Diagnostic `protobuf:"bytes,6,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
}

func (x *Occurrence) Reset() {
	*x = Occurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Occurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Occurrence) ProtoMessage() {}

func (x *Occurrence) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Occurrence.ProtoReflect.Descriptor instead.
func (*Occurrence) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{9}
}

func (x *Occurrence) GetRange() []int32 {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *Occurrence) GetSymbol() string {
	if x != nil {
		return x.Symbol
	}
	return ""
}

func (x *Occurrence) GetSymbolRoles() int32 {
	if x != nil {
		return x.SymbolRoles
	}
	return 0
}

func (x *Occurrence) GetOverrideDocumentation() []string {
	if x != nil {
		return x.OverrideDocumentation
	}
	return nil
}

func (x *Occurrence) GetSyntaxKind() SyntaxKind {
	if x != nil {
		return x.SyntaxKind
	}
	return SyntaxKind_UnspecifiedSyntaxKind
}

func (x *Occurrence) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Represents a diagnostic, such as a compiler error or warning, which should be
// reported for a document.
type Diagnostic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Should this diagnostic be reported as an error, warning, info, or hint?
	Severity Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=scip.Severity" json:"severity,omitempty"`
	// (optional) Code of this diagnostic, which might appear in the user interface.
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
	// Message of this diagnostic.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (optional) Human-readable string describing the source of this diagnostic, e.g.
	// 'typescript' or 'super lint'.
	Source string          `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	Tags   []DiagnosticTag `protobuf:"varint,5,rep,packed,name=tags,proto3,enum=scip.DiagnosticTag" json:"tags,omitempty"`
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_scip_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_scip_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_scip_proto_rawDescGZIP(), []int{10}
}

func (x *Diagnostic) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_UnspecifiedSeverity
}

func (x *Diagnostic) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *Diagnostic) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Diagnostic) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Diagnostic) GetTags() []DiagnosticTag {
	if x != nil {
		return x.Tags
	}
	return nil
}

var File_scip_proto protoreflect.FileDescriptor

var file_scip_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x04, 0x73, 0x63,
	0x69, 0x70, 0x22, 0xa5, 0x01, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2a, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e,
	0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x63,
	0x69, 0x70, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x22, 0xd5, 0x01, 0x0a, 0x08, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x63,
	0x69, 0x70, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x74, 0x6f, 0x6f,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x48, 0x0a, 0x16, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x74, 0x65,
	0x78, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0x56, 0x0a, 0x08, 0x54, 0x6f, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb2, 0x01, 0x0a, 0x08, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x32, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e,
	0x73, 0x63, 0x69, 0x70, 0x2e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x07,
	0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x73, 0x63, 0x69, 0x70, 0x2e, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x22,
	0x7d, 0x0a, 0x06, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x12, 0x27, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x10, 0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x51,
	0x0a, 0x07, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x9f, 0x02, 0x0a, 0x0a, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x69, 0x67,
	0x75, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x73,
	0x61, 0x6d, 0x62, 0x69, 0x67, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x73, 0x63, 0x69,
	0x70, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x53, 0x75, 0x66,
	0x66, 0x69, 0x78, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x22, 0xa5, 0x01, 0x0a, 0x06,
	0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x07,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x65, 0x72, 0x6d, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x10, 0x04, 0x12, 0x11, 0x0a,
	0x0d, 0x54, 0x79, 0x70, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x10, 0x05,
	0x12, 0x0d, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x10, 0x06, 0x12,
	0x09, 0x0a, 0x05, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x10, 0x09, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x65,
	0x74, 0x61, 0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x10, 0x08, 0x1a,
	0x02, 0x10, 0x01, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x79, 0x6d,
	0x62, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f,
	0x6c, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x73, 0x63, 0x69, 0x70, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x52, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70,
	0x73, 0x22, 0xc9, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x73,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x69, 0x73, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2b, 0x0a,
	0x11, 0x69, 0x73, 0x5f, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x73, 0x49, 0x6d, 0x70, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x73,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x73, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x69, 0x73, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfb, 0x01,
	0x0a, 0x0a, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x05, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x79,
	0x6d, 0x62, 0x6f, 0x6c, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x35, 0x0a,
	0x16, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x0b, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x5f, 0x6b,
	0x69, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x73, 0x63, 0x69, 0x70,
	0x2e, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0a, 0x73, 0x79, 0x6e,
	0x74, 0x61, 0x78, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x32, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x73,
	0x63, 0x69, 0x70, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b,
	0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xa7, 0x01, 0x0a, 0x0a,
	0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x2a, 0x0a, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x73,
	0x63, 0x69, 0x70, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x73, 0x63, 0x69,
	0x70, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x54, 0x61, 0x67, 0x52,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x2a, 0x31, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x10, 0x00, 0x2a, 0x40, 0x0a, 0x0c, 0x54, 0x65, 0x78, 0x74,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1b, 0x0a, 0x17, 0x55, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x54, 0x46, 0x38, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x55, 0x54, 0x46, 0x31, 0x36, 0x10, 0x02, 0x2a, 0x7d, 0x0a, 0x0a, 0x53, 0x79,
	0x6d, 0x62, 0x6f, 0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x52, 0x6f, 0x6c,
	0x65, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x10, 0x04,
	0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x65, 0x61, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x10, 0x08,
	0x12, 0x0d, 0x0a, 0x09, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x10, 0x10, 0x12,
	0x08, 0x0a, 0x04, 0x54, 0x65, 0x73, 0x74, 0x10, 0x20, 0x2a, 0xea, 0x06, 0x0a, 0x0a, 0x53, 0x79,
	0x6e, 0x74, 0x61, 0x78, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x4b, 0x69, 0x6e,
	0x64, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x10, 0x01,
	0x12, 0x18, 0x0a, 0x14, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x75,
	0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x10, 0x04, 0x12,
	0x19, 0x0a, 0x11, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x42, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4e, 0x75, 0x6c, 0x6c, 0x10, 0x08, 0x12, 0x16, 0x0a,
	0x12, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x10, 0x09, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x10, 0x0b, 0x12, 0x13, 0x0a, 0x0f, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x10, 0x0c,
	0x12, 0x16, 0x0a, 0x12, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x68,
	0x61, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x10, 0x0d, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x10,
	0x0e, 0x12, 0x18, 0x0a, 0x10, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x10, 0x0e, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x10, 0x0f, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x10, 0x10, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x10, 0x11, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x10, 0x13, 0x12, 0x19, 0x0a,
	0x15, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x42, 0x75, 0x69, 0x6c, 0x74,
	0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x10, 0x14, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x10,
	0x15, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x65, 0x67, 0x65, 0x78, 0x45, 0x73, 0x63, 0x61, 0x70, 0x65,
	0x10, 0x16, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x65, 0x67, 0x65, 0x78, 0x52, 0x65, 0x70, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x10, 0x17, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x65, 0x67, 0x65, 0x78, 0x57, 0x69,
	0x6c, 0x64, 0x63, 0x61, 0x72, 0x64, 0x10, 0x18, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x65, 0x67, 0x65,
	0x78, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x10, 0x19, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x65, 0x67, 0x65, 0x78, 0x4a, 0x6f, 0x69, 0x6e, 0x10, 0x1a, 0x12, 0x11, 0x0a, 0x0d, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x10, 0x1b, 0x12, 0x17,
	0x0a, 0x13, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x45,
	0x73, 0x63, 0x61, 0x70, 0x65, 0x10, 0x1c, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x10,
	0x1d, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x4b, 0x65, 0x79, 0x10, 0x1e, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x10, 0x1f, 0x12, 0x12, 0x0a,
	0x0e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x10,
	0x20, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x4c, 0x69, 0x74, 0x65,
	0x72, 0x61, 0x6c, 0x10, 0x21, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x10, 0x22, 0x12, 0x10,
	0x0a, 0x0c, 0x54, 0x61, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x10, 0x23,
	0x12, 0x10, 0x0a, 0x0c, 0x54, 0x61, 0x67, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72,
	0x10, 0x24, 0x1a, 0x02, 0x10, 0x01, 0x2a, 0x56, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65,
	0x64, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x69, 0x6e, 0x74, 0x10, 0x04, 0x2a, 0x4e,
	0x0a, 0x0d, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x54, 0x61, 0x67, 0x12,
	0x1c, 0x0a, 0x18, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x44, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x54, 0x61, 0x67, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x6e, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72, 0x79, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x10, 0x02, 0x2a, 0xe0,
	0x08, 0x0a, 0x08, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x55,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x42, 0x41, 0x50, 0x10, 0x3c, 0x12, 0x07,
	0x0a, 0x03, 0x41, 0x50, 0x4c, 0x10, 0x31, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x64, 0x61, 0x10, 0x27,
	0x12, 0x08, 0x0a, 0x04, 0x41, 0x67, 0x64, 0x61, 0x10, 0x2d, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x73,
	0x63, 0x69, 0x69, 0x44, 0x6f, 0x63, 0x10, 0x56, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x73, 0x73, 0x65,
	0x6d, 0x62, 0x6c, 0x79, 0x10, 0x3a, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x77, 0x6b, 0x10, 0x42, 0x12,
	0x07, 0x0a, 0x03, 0x42, 0x61, 0x74, 0x10, 0x44, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x69, 0x62, 0x54,
	0x65, 0x58, 0x10, 0x51, 0x12, 0x05, 0x0a, 0x01, 0x43, 0x10, 0x22, 0x12, 0x09, 0x0a, 0x05, 0x43,
	0x4f, 0x42, 0x4f, 0x4c, 0x10, 0x3b, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x50, 0x50, 0x10, 0x23, 0x12,
	0x07, 0x0a, 0x03, 0x43, 0x53, 0x53, 0x10, 0x1a, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x53, 0x68, 0x61,
	0x72, 0x70, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x6c, 0x6f, 0x6a, 0x75, 0x72, 0x65, 0x10,
	0x08, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x10, 0x15, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4c, 0x69, 0x73,
	0x70, 0x10, 0x09, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x6f, 0x71, 0x10, 0x2f, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x61, 0x72, 0x74, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x70, 0x68, 0x69,
	0x10, 0x39, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x69, 0x66, 0x66, 0x10, 0x58, 0x12, 0x0e, 0x0a, 0x0a,
	0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x66, 0x69, 0x6c, 0x65, 0x10, 0x50, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x79, 0x61, 0x6c, 0x6f, 0x67, 0x10, 0x32, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x6c, 0x69, 0x78,
	0x69, 0x72, 0x10, 0x11, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x72, 0x6c, 0x61, 0x6e, 0x67, 0x10, 0x12,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x53, 0x68, 0x61, 0x72, 0x70, 0x10, 0x2a, 0x12, 0x08, 0x0a, 0x04,
	0x46, 0x69, 0x73, 0x68, 0x10, 0x41, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x6c, 0x6f, 0x77, 0x10, 0x18,
	0x12, 0x0b, 0x0a, 0x07, 0x46, 0x6f, 0x72, 0x74, 0x72, 0x61, 0x6e, 0x10, 0x38, 0x12, 0x0e, 0x0a,
	0x0a, 0x47, 0x69, 0x74, 0x5f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x10, 0x5b, 0x12, 0x0e, 0x0a,
	0x0a, 0x47, 0x69, 0x74, 0x5f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10, 0x59, 0x12, 0x0e, 0x0a,
	0x0a, 0x47, 0x69, 0x74, 0x5f, 0x52, 0x65, 0x62, 0x61, 0x73, 0x65, 0x10, 0x5c, 0x12, 0x06, 0x0a,
	0x02, 0x47, 0x6f, 0x10, 0x21, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x72, 0x6f, 0x6f, 0x76, 0x79, 0x10,
	0x07, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x54, 0x4d, 0x4c, 0x10, 0x1e, 0x12, 0x08, 0x0a, 0x04, 0x48,
	0x61, 0x63, 0x6b, 0x10, 0x14, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x62,
	0x61, 0x72, 0x73, 0x10, 0x5a, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x61, 0x73, 0x6b, 0x65, 0x6c, 0x6c,
	0x10, 0x2c, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x64, 0x72, 0x69, 0x73, 0x10, 0x2e, 0x12, 0x07, 0x0a,
	0x03, 0x49, 0x6e, 0x69, 0x10, 0x48, 0x12, 0x05, 0x0a, 0x01, 0x4a, 0x10, 0x33, 0x12, 0x08, 0x0a,
	0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x4b, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x61, 0x76, 0x61, 0x10,
	0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x10,
	0x16, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52,
	0x65, 0x61, 0x63, 0x74, 0x10, 0x5d, 0x12, 0x0b, 0x0a, 0x07, 0x4a, 0x73, 0x6f, 0x6e, 0x6e, 0x65,
	0x74, 0x10, 0x4c, 0x12, 0x09, 0x0a, 0x05, 0x4a, 0x75, 0x6c, 0x69, 0x61, 0x10, 0x37, 0x12, 0x0a,
	0x0a, 0x06, 0x4b, 0x6f, 0x74, 0x6c, 0x69, 0x6e, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x61,
	0x54, 0x65, 0x58, 0x10, 0x53, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x65, 0x61, 0x6e, 0x10, 0x30, 0x12,
	0x08, 0x0a, 0x04, 0x4c, 0x65, 0x73, 0x73, 0x10, 0x1b, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x75, 0x61,
	0x10, 0x0c, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x61, 0x6b, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x10, 0x4f,
	0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x61, 0x72, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x10, 0x54, 0x12, 0x0a,
	0x0a, 0x06, 0x4d, 0x61, 0x74, 0x6c, 0x61, 0x62, 0x10, 0x34, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x69,
	0x78, 0x10, 0x4d, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x43, 0x61, 0x6d, 0x6c, 0x10, 0x29, 0x12, 0x0f,
	0x0a, 0x0b, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x43, 0x10, 0x24, 0x12,
	0x11, 0x0a, 0x0d, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x43, 0x50, 0x50,
	0x10, 0x25, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x48, 0x50, 0x10, 0x13, 0x12, 0x09, 0x0a, 0x05, 0x50,
	0x4c, 0x53, 0x51, 0x4c, 0x10, 0x46, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x65, 0x72, 0x6c, 0x10, 0x0d,
	0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x10, 0x43,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x72, 0x6f, 0x6c, 0x6f, 0x67, 0x10, 0x47, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x10, 0x0f, 0x12, 0x05, 0x0a, 0x01, 0x52, 0x10, 0x36, 0x12,
	0x0a, 0x0a, 0x06, 0x52, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x10, 0x0b, 0x12, 0x08, 0x0a, 0x04, 0x52,
	0x61, 0x6b, 0x75, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x61, 0x7a, 0x6f, 0x72, 0x10, 0x3e,
	0x12, 0x08, 0x0a, 0x04, 0x52, 0x65, 0x53, 0x54, 0x10, 0x55, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x75,
	0x62, 0x79, 0x10, 0x10, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x75, 0x73, 0x74, 0x10, 0x28, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x41, 0x53, 0x10, 0x3d, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x43, 0x53, 0x53, 0x10,
	0x1d, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x4d, 0x4c, 0x10, 0x2b, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x51,
	0x4c, 0x10, 0x45, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x61, 0x73, 0x73, 0x10, 0x1c, 0x12, 0x09, 0x0a,
	0x05, 0x53, 0x63, 0x61, 0x6c, 0x61, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x65, 0x10, 0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x53, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x10, 0x40, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x6b, 0x79, 0x6c, 0x61, 0x72, 0x6b,
	0x10, 0x4e, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x77, 0x69, 0x66, 0x74, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x54, 0x4f, 0x4d, 0x4c, 0x10, 0x49, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x65, 0x58, 0x10, 0x52,
	0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x79, 0x70, 0x65, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x10, 0x17,
	0x12, 0x13, 0x0a, 0x0f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65,
	0x61, 0x63, 0x74, 0x10, 0x5e, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x42,
	0x61, 0x73, 0x69, 0x63, 0x10, 0x3f, 0x12, 0x07, 0x0a, 0x03, 0x56, 0x75, 0x65, 0x10, 0x19, 0x12,
	0x0b, 0x0a, 0x07, 0x57, 0x6f, 0x6c, 0x66, 0x72, 0x61, 0x6d, 0x10, 0x35, 0x12, 0x07, 0x0a, 0x03,
	0x58, 0x4d, 0x4c, 0x10, 0x1f, 0x12, 0x07, 0x0a, 0x03, 0x58, 0x53, 0x4c, 0x10, 0x20, 0x12, 0x08,
	0x0a, 0x04, 0x59, 0x41, 0x4d, 0x4c, 0x10, 0x4a, 0x12, 0x07, 0x0a, 0x03, 0x5a, 0x69, 0x67, 0x10,
	0x26, 0x42, 0x2f, 0x5a, 0x2d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2f, 0x73, 0x63, 0x69, 0x70,
	0x2f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x63, 0x69,
	0x70, 0x2f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_scip_proto_rawDescOnce sync.Once
	file_scip_proto_rawDescData = file_scip_proto_rawDesc
)

func file_scip_proto_rawDescGZIP() []byte {
	file_scip_proto_rawDescOnce.Do(func() {
		file_scip_proto_rawDescData = protoimpl.X.CompressGZIP(file_scip_proto_rawDescData)
	})
	return file_scip_proto_rawDescData
}

var file_scip_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_scip_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_scip_proto_goTypes = []interface{}{
	(ProtocolVersion)(0),      // 0: scip.ProtocolVersion
	(TextEncoding)(0),         // 1: scip.TextEncoding
	(SymbolRole)(0),           // 2: scip.SymbolRole
	(SyntaxKind)(0),           // 3: scip.SyntaxKind
	(Severity)(0),             // 4: scip.Severity
	(DiagnosticTag)(0),        // 5: scip.DiagnosticTag
	(Language)(0),             // 6: scip.Language
	(Descriptor_Suffix)(0),    // 7: scip.Descriptor.Suffix
	(*Index)(nil),             // 8: scip.Index
	(*Metadata)(nil),          // 9: scip.Metadata
	(*ToolInfo)(nil),          // 10: scip.ToolInfo
	(*Document)(nil),          // 11: scip.Document
	(*Symbol)(nil),            // 12: scip.Symbol
	(*Package)(nil),           // 13: scip.Package
	(*Descriptor)(nil),        // 14: scip.Descriptor
	(*SymbolInformation)(nil), // 15: scip.SymbolInformation
	(*Relationship)(nil),      // 16: scip.Relationship
	(*Occurrence)(nil),        // 17: scip.Occurrence
	(*Diagnostic)(nil),        // 18: scip.Diagnostic
}
var file_scip_proto_depIdxs = []int32{
	9,  // 0: scip.Index.metadata:type_name -> scip.Metadata
	11, // 1: scip.Index.documents:type_name -> scip.Document
	15, // 2: scip.Index.external_symbols:type_name -> scip.SymbolInformation
	0,  // 3: scip.Metadata.version:type_name -> scip.ProtocolVersion
	10, // 4: scip.Metadata.tool_info:type_name -> scip.ToolInfo
	1,  // 5: scip.Metadata.text_document_encoding:type_name -> scip.TextEncoding
	17, // 6: scip.Document.occurrences:type_name -> scip.Occurrence
	15, // 7: scip.Document.symbols:type_name -> scip.SymbolInformation
	13, // 8: scip.Symbol.package:type_name -> scip.Package
	14, // 9: scip.Symbol.descriptors:type_name -> scip.Descriptor
	7,  // 10: scip.Descriptor.suffix:type_name -> scip.Descriptor.Suffix
	16, // 11: scip.SymbolInformation.relationships:type_name -> scip.Relationship
	3,  // 12: scip.Occurrence.syntax_kind:type_name -> scip.SyntaxKind
	18, // 13: scip.Occurrence.diagnostics:type_name -> scip.Diagnostic
	4,  // 14: scip.Diagnostic.severity:type_name -> scip.Severity
	5,  // 15: scip.Diagnostic.tags:type_name -> scip.DiagnosticTag
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_scip_proto_init() }
func file_scip_proto_init() {
	if File_scip_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_scip_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Symbol); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Descriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SymbolInformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Relationship); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Occurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_scip_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Diagnostic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_scip_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_scip_proto_goTypes,
		DependencyIndexes: file_scip_proto_depIdxs,
		EnumInfos:         file_scip_proto_enumTypes,
		MessageInfos:      file_scip_proto_msgTypes,
	}.Build()
	File_scip_proto = out.File
	file_scip_proto_rawDesc = nil
	file_scip_proto_goTypes = nil
	file_scip_proto_depIdxs = nil
}
