/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>

/* Copied from Qualcomm previous generation SoC SC7280 and need cleanup */

/* SYSTEM_IMEM : 0x14680000 - 0x146AB000 */
#define SSRAM_START(addr) REGION_START(ssram, addr)
#define SSRAM_END(addr) REGION_END(ssram, addr)

/* BOOT_IMEM   : 0x14800000 - 0x14980000 */
#define BSRAM_START(addr) REGION_START(bsram, addr)
#define BSRAM_END(addr) REGION_END(bsram, addr)

/* AOP : 0x0B000000 - 0x0B100000 */
#define AOPSRAM_START(addr) REGION_START(aopsram, addr)
#define AOPSRAM_END(addr) REGION_END(aopsram, addr)

SECTIONS
{
	REGION(shrm, 0x09060000, 64K , 4K)

	AOPSRAM_START(0x0B000000)
	REGION(aop_code_ram, 0x0B000000, 0x80000, 4096)
	REGION(aop_data_ram, 0x0B0E0000, 0x20000, 4096)
	AOPSRAM_END(0x0B100000)

	SSRAM_START(0x14680000)
	OVERLAP_DECOMPRESSOR_VERSTAGE_ROMSTAGE(0x14680000, 132K)
	REGION(qcsdi, 0x146A1000, 40K, 4K)
	SSRAM_END(0x146AB000)

	BSRAM_START(0x14800000)
	REGION(pbl_timestamps, 0x14800000, 84K, 4K)
	WATCHDOG_TOMBSTONE(0x14818FFC, 4)
	BOOTBLOCK(0x14819000, 60K)
	PRERAM_CBFS_CACHE(0x14828000, 103K)
	TIMESTAMP(0x14841C00, 1K)
	TTB(0x14842000, 56K)
	STACK(0x14850000, 16K)
	VBOOT2_WORK(0x14854000, 12K)
	DMA_COHERENT(0x14857000, 8K)
	REGION(qclib_serial_log, 0x1485B000, 4K, 4K)
	CBFS_MCACHE(0x1485C000,16K)
	REGION(ddr_information, 0x14860000, 1K, 1K)
	FMAP_CACHE(0x14860400, 2K)
	REGION(dcb, 0x14862000, 32K, 4K)
	REGION(pmic, 0x1486A000, 96K, 4K)
	REGION(ddr_training, 0x14882000, 32K, 4K)
	REGION(qclib, 0x1488A000, 800K, 4K)
	PRERAM_CBMEM_CONSOLE(0x14954000, 32K)
	BSRAM_END(0x1495C000)

	DRAM_START(0x80000000)
	POSTRAM_CBFS_CACHE(0x9F800000, 16M)
	RAMSTAGE(0xA0800000, 16M)
	BL31(0xC0000000, 1M)
}
