// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package timestreamwrite

import (
	"fmt"
	"net/url"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/crr"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateBatchLoadTask = "CreateBatchLoadTask"

// CreateBatchLoadTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchLoadTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchLoadTask for more information on using the CreateBatchLoadTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBatchLoadTaskRequest method.
//	req, resp := client.CreateBatchLoadTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateBatchLoadTask
func (c *TimestreamWrite) CreateBatchLoadTaskRequest(input *CreateBatchLoadTaskInput) (req *request.Request, output *CreateBatchLoadTaskOutput) {
	op := &request.Operation{
		Name:       opCreateBatchLoadTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchLoadTaskInput{}
	}

	output = &CreateBatchLoadTaskOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateBatchLoadTask API operation for Amazon Timestream Write.
//
// Creates a new Timestream batch load task. A batch load task processes data
// from a CSV source in an S3 location and writes to a Timestream table. A mapping
// from source to target is defined in a batch load task. Errors and events
// are written to a report at an S3 location. For the report, if the KMS key
// is not specified, the batch load task will be encrypted with a Timestream
// managed KMS key located in your account. For more information, see Amazon
// Web Services managed keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
// Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// For details, see code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation CreateBatchLoadTask for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ConflictException
//     Timestream was unable to process this request because it contains resource
//     that already exists.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateBatchLoadTask
func (c *TimestreamWrite) CreateBatchLoadTask(input *CreateBatchLoadTaskInput) (*CreateBatchLoadTaskOutput, error) {
	req, out := c.CreateBatchLoadTaskRequest(input)
	return out, req.Send()
}

// CreateBatchLoadTaskWithContext is the same as CreateBatchLoadTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchLoadTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) CreateBatchLoadTaskWithContext(ctx aws.Context, input *CreateBatchLoadTaskInput, opts ...request.Option) (*CreateBatchLoadTaskOutput, error) {
	req, out := c.CreateBatchLoadTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatabase = "CreateDatabase"

// CreateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatabase for more information on using the CreateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatabaseRequest method.
//	req, resp := client.CreateDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase
func (c *TimestreamWrite) CreateDatabaseRequest(input *CreateDatabaseInput) (req *request.Request, output *CreateDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatabaseInput{}
	}

	output = &CreateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateDatabase API operation for Amazon Timestream Write.
//
// Creates a new Timestream database. If the KMS key is not specified, the database
// will be encrypted with a Timestream managed KMS key located in your account.
// For more information, see Amazon Web Services managed keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
// Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// For details, see code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation CreateDatabase for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Timestream was unable to process this request because it contains resource
//     that already exists.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateDatabase
func (c *TimestreamWrite) CreateDatabase(input *CreateDatabaseInput) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	return out, req.Send()
}

// CreateDatabaseWithContext is the same as CreateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) CreateDatabaseWithContext(ctx aws.Context, input *CreateDatabaseInput, opts ...request.Option) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTableRequest method.
//	req, resp := client.CreateTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable
func (c *TimestreamWrite) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateTable API operation for Amazon Timestream Write.
//
// Adds a new table to an existing database in your account. In an Amazon Web
// Services account, table names must be at least unique within each Region
// if they are in the same database. You might have identical table names in
// the same Region if the tables are in separate databases. While creating the
// table, you must specify the table name, database name, and the retention
// properties. Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation CreateTable for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Timestream was unable to process this request because it contains resource
//     that already exists.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/CreateTable
func (c *TimestreamWrite) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatabase = "DeleteDatabase"

// DeleteDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatabase for more information on using the DeleteDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatabaseRequest method.
//	req, resp := client.DeleteDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase
func (c *TimestreamWrite) DeleteDatabaseRequest(input *DeleteDatabaseInput) (req *request.Request, output *DeleteDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatabaseInput{}
	}

	output = &DeleteDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteDatabase API operation for Amazon Timestream Write.
//
// Deletes a given Timestream database. This is an irreversible operation. After
// a database is deleted, the time-series data from its tables cannot be recovered.
//
// All tables in the database must be deleted first, or a ValidationException
// error will be thrown.
//
// Due to the nature of distributed retries, the operation can return either
// success or a ResourceNotFoundException. Clients should consider them equivalent.
//
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DeleteDatabase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteDatabase
func (c *TimestreamWrite) DeleteDatabase(input *DeleteDatabaseInput) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	return out, req.Send()
}

// DeleteDatabaseWithContext is the same as DeleteDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DeleteDatabaseWithContext(ctx aws.Context, input *DeleteDatabaseInput, opts ...request.Option) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTableRequest method.
//	req, resp := client.DeleteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable
func (c *TimestreamWrite) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteTable API operation for Amazon Timestream Write.
//
// Deletes a given Timestream table. This is an irreversible operation. After
// a Timestream database table is deleted, the time-series data stored in the
// table cannot be recovered.
//
// Due to the nature of distributed retries, the operation can return either
// success or a ResourceNotFoundException. Clients should consider them equivalent.
//
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DeleteTable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DeleteTable
func (c *TimestreamWrite) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBatchLoadTask = "DescribeBatchLoadTask"

// DescribeBatchLoadTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBatchLoadTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBatchLoadTask for more information on using the DescribeBatchLoadTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBatchLoadTaskRequest method.
//	req, resp := client.DescribeBatchLoadTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeBatchLoadTask
func (c *TimestreamWrite) DescribeBatchLoadTaskRequest(input *DescribeBatchLoadTaskInput) (req *request.Request, output *DescribeBatchLoadTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeBatchLoadTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBatchLoadTaskInput{}
	}

	output = &DescribeBatchLoadTaskOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeBatchLoadTask API operation for Amazon Timestream Write.
//
// Returns information about the batch load task, including configurations,
// mappings, progress, and other details. Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeBatchLoadTask for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeBatchLoadTask
func (c *TimestreamWrite) DescribeBatchLoadTask(input *DescribeBatchLoadTaskInput) (*DescribeBatchLoadTaskOutput, error) {
	req, out := c.DescribeBatchLoadTaskRequest(input)
	return out, req.Send()
}

// DescribeBatchLoadTaskWithContext is the same as DescribeBatchLoadTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBatchLoadTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeBatchLoadTaskWithContext(ctx aws.Context, input *DescribeBatchLoadTaskInput, opts ...request.Option) (*DescribeBatchLoadTaskOutput, error) {
	req, out := c.DescribeBatchLoadTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatabase = "DescribeDatabase"

// DescribeDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatabase for more information on using the DescribeDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatabaseRequest method.
//	req, resp := client.DescribeDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase
func (c *TimestreamWrite) DescribeDatabaseRequest(input *DescribeDatabaseInput) (req *request.Request, output *DescribeDatabaseOutput) {
	op := &request.Operation{
		Name:       opDescribeDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatabaseInput{}
	}

	output = &DescribeDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeDatabase API operation for Amazon Timestream Write.
//
// Returns information about the database, including the database name, time
// that the database was created, and the total number of tables found within
// the database. Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeDatabase for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeDatabase
func (c *TimestreamWrite) DescribeDatabase(input *DescribeDatabaseInput) (*DescribeDatabaseOutput, error) {
	req, out := c.DescribeDatabaseRequest(input)
	return out, req.Send()
}

// DescribeDatabaseWithContext is the same as DescribeDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeDatabaseWithContext(ctx aws.Context, input *DescribeDatabaseInput, opts ...request.Option) (*DescribeDatabaseOutput, error) {
	req, out := c.DescribeDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointsRequest method.
//	req, resp := client.DescribeEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints
func (c *TimestreamWrite) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for Amazon Timestream Write.
//
// Returns a list of available endpoints to make Timestream API calls against.
// This API operation is available through both the Write and Query APIs.
//
// Because the Timestream SDKs are designed to transparently work with the service’s
// architecture, including the management and mapping of the service endpoints,
// we don't recommend that you use this API operation unless:
//
//   - You are using VPC endpoints (Amazon Web Services PrivateLink) with Timestream
//     (https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints)
//
//   - Your application uses a programming language that does not yet have
//     SDK support
//
//   - You require better control over the client-side implementation
//
// For detailed information on how and when to use and implement DescribeEndpoints,
// see The Endpoint Discovery Pattern (https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeEndpoints
func (c *TimestreamWrite) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type discovererDescribeEndpoints struct {
	Client        *TimestreamWrite
	Required      bool
	EndpointCache *crr.EndpointCache
	Params        map[string]*string
	Key           string
	req           *request.Request
}

func (d *discovererDescribeEndpoints) Discover() (crr.Endpoint, error) {
	input := &DescribeEndpointsInput{}

	resp, err := d.Client.DescribeEndpoints(input)
	if err != nil {
		return crr.Endpoint{}, err
	}

	endpoint := crr.Endpoint{
		Key: d.Key,
	}

	for _, e := range resp.Endpoints {
		if e.Address == nil {
			continue
		}

		address := *e.Address

		var scheme string
		if idx := strings.Index(address, "://"); idx != -1 {
			scheme = address[:idx]
		}

		if len(scheme) == 0 {
			address = fmt.Sprintf("%s://%s", d.req.HTTPRequest.URL.Scheme, address)
		}

		cachedInMinutes := aws.Int64Value(e.CachePeriodInMinutes)
		u, err := url.Parse(address)
		if err != nil {
			continue
		}

		addr := crr.WeightedAddress{
			URL:     u,
			Expired: time.Now().Add(time.Duration(cachedInMinutes) * time.Minute),
		}

		endpoint.Add(addr)
	}

	d.EndpointCache.Add(endpoint)

	return endpoint, nil
}

func (d *discovererDescribeEndpoints) Handler(r *request.Request) {
	endpointKey := crr.BuildEndpointKey(d.Params)
	d.Key = endpointKey
	d.req = r

	endpoint, err := d.EndpointCache.Get(d, endpointKey, d.Required)
	if err != nil {
		r.Error = err
		return
	}

	if endpoint.URL != nil && len(endpoint.URL.String()) > 0 {
		r.HTTPRequest.URL = endpoint.URL
	}
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTable for more information on using the DescribeTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTableRequest method.
//	req, resp := client.DescribeTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable
func (c *TimestreamWrite) DescribeTableRequest(input *DescribeTableInput) (req *request.Request, output *DescribeTableOutput) {
	op := &request.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	output = &DescribeTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeTable API operation for Amazon Timestream Write.
//
// Returns information about the table, including the table name, database name,
// retention duration of the memory store and the magnetic store. Service quotas
// apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation DescribeTable for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/DescribeTable
func (c *TimestreamWrite) DescribeTable(input *DescribeTableInput) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	return out, req.Send()
}

// DescribeTableWithContext is the same as DescribeTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) DescribeTableWithContext(ctx aws.Context, input *DescribeTableInput, opts ...request.Option) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBatchLoadTasks = "ListBatchLoadTasks"

// ListBatchLoadTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListBatchLoadTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBatchLoadTasks for more information on using the ListBatchLoadTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBatchLoadTasksRequest method.
//	req, resp := client.ListBatchLoadTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks
func (c *TimestreamWrite) ListBatchLoadTasksRequest(input *ListBatchLoadTasksInput) (req *request.Request, output *ListBatchLoadTasksOutput) {
	op := &request.Operation{
		Name:       opListBatchLoadTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchLoadTasksInput{}
	}

	output = &ListBatchLoadTasksOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListBatchLoadTasks API operation for Amazon Timestream Write.
//
// Provides a list of batch load tasks, along with the name, status, when the
// task is resumable until, and other details. See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListBatchLoadTasks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListBatchLoadTasks
func (c *TimestreamWrite) ListBatchLoadTasks(input *ListBatchLoadTasksInput) (*ListBatchLoadTasksOutput, error) {
	req, out := c.ListBatchLoadTasksRequest(input)
	return out, req.Send()
}

// ListBatchLoadTasksWithContext is the same as ListBatchLoadTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListBatchLoadTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListBatchLoadTasksWithContext(ctx aws.Context, input *ListBatchLoadTasksInput, opts ...request.Option) (*ListBatchLoadTasksOutput, error) {
	req, out := c.ListBatchLoadTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBatchLoadTasksPages iterates over the pages of a ListBatchLoadTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBatchLoadTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBatchLoadTasks operation.
//	pageNum := 0
//	err := client.ListBatchLoadTasksPages(params,
//	    func(page *timestreamwrite.ListBatchLoadTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TimestreamWrite) ListBatchLoadTasksPages(input *ListBatchLoadTasksInput, fn func(*ListBatchLoadTasksOutput, bool) bool) error {
	return c.ListBatchLoadTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBatchLoadTasksPagesWithContext same as ListBatchLoadTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListBatchLoadTasksPagesWithContext(ctx aws.Context, input *ListBatchLoadTasksInput, fn func(*ListBatchLoadTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBatchLoadTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBatchLoadTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBatchLoadTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatabases for more information on using the ListDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatabasesRequest method.
//	req, resp := client.ListDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases
func (c *TimestreamWrite) ListDatabasesRequest(input *ListDatabasesInput) (req *request.Request, output *ListDatabasesOutput) {
	op := &request.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	output = &ListDatabasesOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListDatabases API operation for Amazon Timestream Write.
//
// Returns a list of your Timestream databases. Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListDatabases for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListDatabases
func (c *TimestreamWrite) ListDatabases(input *ListDatabasesInput) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	return out, req.Send()
}

// ListDatabasesWithContext is the same as ListDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListDatabasesWithContext(ctx aws.Context, input *ListDatabasesInput, opts ...request.Option) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatabasesPages iterates over the pages of a ListDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatabases operation.
//	pageNum := 0
//	err := client.ListDatabasesPages(params,
//	    func(page *timestreamwrite.ListDatabasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TimestreamWrite) ListDatabasesPages(input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool) error {
	return c.ListDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatabasesPagesWithContext same as ListDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListDatabasesPagesWithContext(ctx aws.Context, input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTablesRequest method.
//	req, resp := client.ListTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables
func (c *TimestreamWrite) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTables API operation for Amazon Timestream Write.
//
// Provides a list of tables, along with the name, status, and retention properties
// of each table. See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTables
func (c *TimestreamWrite) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTables operation.
//	pageNum := 0
//	err := client.ListTablesPages(params,
//	    func(page *timestreamwrite.ListTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TimestreamWrite) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource
func (c *TimestreamWrite) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTagsForResource API operation for Amazon Timestream Write.
//
// Lists all tags on a Timestream resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ListTagsForResource
func (c *TimestreamWrite) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeBatchLoadTask = "ResumeBatchLoadTask"

// ResumeBatchLoadTaskRequest generates a "aws/request.Request" representing the
// client's request for the ResumeBatchLoadTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeBatchLoadTask for more information on using the ResumeBatchLoadTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResumeBatchLoadTaskRequest method.
//	req, resp := client.ResumeBatchLoadTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ResumeBatchLoadTask
func (c *TimestreamWrite) ResumeBatchLoadTaskRequest(input *ResumeBatchLoadTaskInput) (req *request.Request, output *ResumeBatchLoadTaskOutput) {
	op := &request.Operation{
		Name:       opResumeBatchLoadTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeBatchLoadTaskInput{}
	}

	output = &ResumeBatchLoadTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ResumeBatchLoadTask API operation for Amazon Timestream Write.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation ResumeBatchLoadTask for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/ResumeBatchLoadTask
func (c *TimestreamWrite) ResumeBatchLoadTask(input *ResumeBatchLoadTaskInput) (*ResumeBatchLoadTaskOutput, error) {
	req, out := c.ResumeBatchLoadTaskRequest(input)
	return out, req.Send()
}

// ResumeBatchLoadTaskWithContext is the same as ResumeBatchLoadTask with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeBatchLoadTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) ResumeBatchLoadTaskWithContext(ctx aws.Context, input *ResumeBatchLoadTaskInput, opts ...request.Option) (*ResumeBatchLoadTaskOutput, error) {
	req, out := c.ResumeBatchLoadTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource
func (c *TimestreamWrite) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TagResource API operation for Amazon Timestream Write.
//
// Associates a set of tags with a Timestream resource. You can then activate
// these user-defined tags so that they appear on the Billing and Cost Management
// console for cost allocation tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/TagResource
func (c *TimestreamWrite) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource
func (c *TimestreamWrite) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UntagResource API operation for Amazon Timestream Write.
//
// Removes the association of tags from a Timestream resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UntagResource
func (c *TimestreamWrite) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatabase = "UpdateDatabase"

// UpdateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatabase for more information on using the UpdateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatabaseRequest method.
//	req, resp := client.UpdateDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase
func (c *TimestreamWrite) UpdateDatabaseRequest(input *UpdateDatabaseInput) (req *request.Request, output *UpdateDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatabaseInput{}
	}

	output = &UpdateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateDatabase API operation for Amazon Timestream Write.
//
// Modifies the KMS key for an existing database. While updating the database,
// you must specify the database name and the identifier of the new KMS key
// to be used (KmsKeyId). If there are any concurrent UpdateDatabase requests,
// first writer wins.
//
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UpdateDatabase for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - ServiceQuotaExceededException
//     The instance quota of resource exceeded for this account.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateDatabase
func (c *TimestreamWrite) UpdateDatabase(input *UpdateDatabaseInput) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	return out, req.Send()
}

// UpdateDatabaseWithContext is the same as UpdateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UpdateDatabaseWithContext(ctx aws.Context, input *UpdateDatabaseInput, opts ...request.Option) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTableRequest method.
//	req, resp := client.UpdateTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable
func (c *TimestreamWrite) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateTable API operation for Amazon Timestream Write.
//
// Modifies the retention duration of the memory store and magnetic store for
// your Timestream table. Note that the change in retention duration takes effect
// immediately. For example, if the retention period of the memory store was
// initially set to 2 hours and then changed to 24 hours, the memory store will
// be capable of holding 24 hours of data, but will be populated with 24 hours
// of data 22 hours after this change was made. Timestream does not retrieve
// data from the magnetic store to populate the memory store.
//
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation UpdateTable for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/UpdateTable
func (c *TimestreamWrite) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opWriteRecords = "WriteRecords"

// WriteRecordsRequest generates a "aws/request.Request" representing the
// client's request for the WriteRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See WriteRecords for more information on using the WriteRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the WriteRecordsRequest method.
//	req, resp := client.WriteRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords
func (c *TimestreamWrite) WriteRecordsRequest(input *WriteRecordsInput) (req *request.Request, output *WriteRecordsOutput) {
	op := &request.Operation{
		Name:       opWriteRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &WriteRecordsInput{}
	}

	output = &WriteRecordsOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// WriteRecords API operation for Amazon Timestream Write.
//
// Enables you to write your time-series data into Timestream. You can specify
// a single data point or a batch of data points to be inserted into the system.
// Timestream offers you a flexible schema that auto detects the column names
// and data types for your Timestream tables based on the dimension names and
// data types of the data points you specify when invoking writes into the database.
//
// Timestream supports eventual consistency read semantics. This means that
// when you query data immediately after writing a batch of data into Timestream,
// the query results might not reflect the results of a recently completed write
// operation. The results may also include some stale data. If you repeat the
// query request after a short time, the results should return the latest data.
// Service quotas apply (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
//
// See code sample (https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html)
// for details.
//
// # Upserts
//
// You can use the Version parameter in a WriteRecords request to update data
// points. Timestream tracks a version number with each record. Version defaults
// to 1 when it's not specified for the record in the request. Timestream updates
// an existing record’s measure value along with its Version when it receives
// a write request with a higher Version number for that record. When it receives
// an update request where the measure value is the same as that of the existing
// record, Timestream still updates Version, if it is greater than the existing
// value of Version. You can update a data point as many times as desired, as
// long as the value of Version continuously increases.
//
// For example, suppose you write a new record without indicating Version in
// the request. Timestream stores this record, and set Version to 1. Now, suppose
// you try to update this record with a WriteRecords request of the same record
// with a different measure value but, like before, do not provide Version.
// In this case, Timestream will reject this update with a RejectedRecordsException
// since the updated record’s version is not greater than the existing value
// of Version.
//
// However, if you were to resend the update request with Version set to 2,
// Timestream would then succeed in updating the record’s value, and the Version
// would be set to 2. Next, suppose you sent a WriteRecords request with this
// same record and an identical measure value, but with Version set to 3. In
// this case, Timestream would only update Version to 3. Any further updates
// would need to send a version number greater than 3, or the update requests
// would receive a RejectedRecordsException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Write's
// API operation WriteRecords for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Timestream was unable to fully process this request because of an internal
//     server error.
//
//   - ThrottlingException
//     Too many requests were made by a user and they exceeded the service quotas.
//     The request was throttled.
//
//   - ValidationException
//     An invalid or malformed request.
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     not be specified correctly, or its status might not be ACTIVE.
//
//   - AccessDeniedException
//     You are not authorized to perform this action.
//
//   - RejectedRecordsException
//     WriteRecords would throw this exception in the following cases:
//
//   - Records with duplicate data where there are multiple records with the
//     same dimensions, timestamps, and measure names but: Measure values are
//     different Version is not present in the request or the value of version
//     in the new record is equal to or lower than the existing value In this
//     case, if Timestream rejects data, the ExistingVersion field in the RejectedRecords
//     response will indicate the current record’s version. To force an update,
//     you can resend the request with a version for the record set to a value
//     greater than the ExistingVersion.
//
//   - Records with timestamps that lie outside the retention duration of the
//     memory store.
//
//   - Records with dimensions or measures that exceed the Timestream defined
//     limits.
//
//     For more information, see Quotas (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
//     in the Amazon Timestream Developer Guide.
//
//   - InvalidEndpointException
//     The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-write-2018-11-01/WriteRecords
func (c *TimestreamWrite) WriteRecords(input *WriteRecordsInput) (*WriteRecordsOutput, error) {
	req, out := c.WriteRecordsRequest(input)
	return out, req.Send()
}

// WriteRecordsWithContext is the same as WriteRecords with the addition of
// the ability to pass a context and additional request options.
//
// See WriteRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamWrite) WriteRecordsWithContext(ctx aws.Context, input *WriteRecordsInput, opts ...request.Option) (*WriteRecordsOutput, error) {
	req, out := c.WriteRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the progress of a batch load task.
type BatchLoadProgressReport struct {
	_ struct{} `type:"structure"`

	BytesMetered *int64 `type:"long"`

	FileFailures *int64 `type:"long"`

	ParseFailures *int64 `type:"long"`

	RecordIngestionFailures *int64 `type:"long"`

	RecordsIngested *int64 `type:"long"`

	RecordsProcessed *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadProgressReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadProgressReport) GoString() string {
	return s.String()
}

// SetBytesMetered sets the BytesMetered field's value.
func (s *BatchLoadProgressReport) SetBytesMetered(v int64) *BatchLoadProgressReport {
	s.BytesMetered = &v
	return s
}

// SetFileFailures sets the FileFailures field's value.
func (s *BatchLoadProgressReport) SetFileFailures(v int64) *BatchLoadProgressReport {
	s.FileFailures = &v
	return s
}

// SetParseFailures sets the ParseFailures field's value.
func (s *BatchLoadProgressReport) SetParseFailures(v int64) *BatchLoadProgressReport {
	s.ParseFailures = &v
	return s
}

// SetRecordIngestionFailures sets the RecordIngestionFailures field's value.
func (s *BatchLoadProgressReport) SetRecordIngestionFailures(v int64) *BatchLoadProgressReport {
	s.RecordIngestionFailures = &v
	return s
}

// SetRecordsIngested sets the RecordsIngested field's value.
func (s *BatchLoadProgressReport) SetRecordsIngested(v int64) *BatchLoadProgressReport {
	s.RecordsIngested = &v
	return s
}

// SetRecordsProcessed sets the RecordsProcessed field's value.
func (s *BatchLoadProgressReport) SetRecordsProcessed(v int64) *BatchLoadProgressReport {
	s.RecordsProcessed = &v
	return s
}

// Details about a batch load task.
type BatchLoadTask struct {
	_ struct{} `type:"structure"`

	// The time when the Timestream batch load task was created.
	CreationTime *time.Time `type:"timestamp"`

	// Database name for the database into which a batch load task loads data.
	DatabaseName *string `type:"string"`

	// The time when the Timestream batch load task was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	ResumableUntil *time.Time `type:"timestamp"`

	// Table name for the table into which a batch load task loads data.
	TableName *string `type:"string"`

	// The ID of the batch load task.
	TaskId *string `min:"3" type:"string"`

	// Status of the batch load task.
	TaskStatus *string `type:"string" enum:"BatchLoadStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadTask) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *BatchLoadTask) SetCreationTime(v time.Time) *BatchLoadTask {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchLoadTask) SetDatabaseName(v string) *BatchLoadTask {
	s.DatabaseName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *BatchLoadTask) SetLastUpdatedTime(v time.Time) *BatchLoadTask {
	s.LastUpdatedTime = &v
	return s
}

// SetResumableUntil sets the ResumableUntil field's value.
func (s *BatchLoadTask) SetResumableUntil(v time.Time) *BatchLoadTask {
	s.ResumableUntil = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchLoadTask) SetTableName(v string) *BatchLoadTask {
	s.TableName = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *BatchLoadTask) SetTaskId(v string) *BatchLoadTask {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *BatchLoadTask) SetTaskStatus(v string) *BatchLoadTask {
	s.TaskStatus = &v
	return s
}

// Details about a batch load task.
type BatchLoadTaskDescription struct {
	_ struct{} `type:"structure"`

	// The time when the Timestream batch load task was created.
	CreationTime *time.Time `type:"timestamp"`

	// Data model configuration for a batch load task. This contains details about
	// where a data model for a batch load task is stored.
	DataModelConfiguration *DataModelConfiguration `type:"structure"`

	// Configuration details about the data source for a batch load task.
	DataSourceConfiguration *DataSourceConfiguration `type:"structure"`

	ErrorMessage *string `min:"1" type:"string"`

	// The time when the Timestream batch load task was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Details about the progress of a batch load task.
	ProgressReport *BatchLoadProgressReport `type:"structure"`

	RecordVersion *int64 `type:"long"`

	// Report configuration for a batch load task. This contains details about where
	// error reports are stored.
	ReportConfiguration *ReportConfiguration `type:"structure"`

	ResumableUntil *time.Time `type:"timestamp"`

	TargetDatabaseName *string `type:"string"`

	TargetTableName *string `type:"string"`

	// The ID of the batch load task.
	TaskId *string `min:"3" type:"string"`

	// Status of the batch load task.
	TaskStatus *string `type:"string" enum:"BatchLoadStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadTaskDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchLoadTaskDescription) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *BatchLoadTaskDescription) SetCreationTime(v time.Time) *BatchLoadTaskDescription {
	s.CreationTime = &v
	return s
}

// SetDataModelConfiguration sets the DataModelConfiguration field's value.
func (s *BatchLoadTaskDescription) SetDataModelConfiguration(v *DataModelConfiguration) *BatchLoadTaskDescription {
	s.DataModelConfiguration = v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *BatchLoadTaskDescription) SetDataSourceConfiguration(v *DataSourceConfiguration) *BatchLoadTaskDescription {
	s.DataSourceConfiguration = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchLoadTaskDescription) SetErrorMessage(v string) *BatchLoadTaskDescription {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *BatchLoadTaskDescription) SetLastUpdatedTime(v time.Time) *BatchLoadTaskDescription {
	s.LastUpdatedTime = &v
	return s
}

// SetProgressReport sets the ProgressReport field's value.
func (s *BatchLoadTaskDescription) SetProgressReport(v *BatchLoadProgressReport) *BatchLoadTaskDescription {
	s.ProgressReport = v
	return s
}

// SetRecordVersion sets the RecordVersion field's value.
func (s *BatchLoadTaskDescription) SetRecordVersion(v int64) *BatchLoadTaskDescription {
	s.RecordVersion = &v
	return s
}

// SetReportConfiguration sets the ReportConfiguration field's value.
func (s *BatchLoadTaskDescription) SetReportConfiguration(v *ReportConfiguration) *BatchLoadTaskDescription {
	s.ReportConfiguration = v
	return s
}

// SetResumableUntil sets the ResumableUntil field's value.
func (s *BatchLoadTaskDescription) SetResumableUntil(v time.Time) *BatchLoadTaskDescription {
	s.ResumableUntil = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *BatchLoadTaskDescription) SetTargetDatabaseName(v string) *BatchLoadTaskDescription {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetTableName sets the TargetTableName field's value.
func (s *BatchLoadTaskDescription) SetTargetTableName(v string) *BatchLoadTaskDescription {
	s.TargetTableName = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *BatchLoadTaskDescription) SetTaskId(v string) *BatchLoadTaskDescription {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *BatchLoadTaskDescription) SetTaskStatus(v string) *BatchLoadTaskDescription {
	s.TaskStatus = &v
	return s
}

// Timestream was unable to process this request because it contains resource
// that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateBatchLoadTaskInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBatchLoadTaskInput's
	// String and GoString methods.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true" sensitive:"true"`

	DataModelConfiguration *DataModelConfiguration `type:"structure"`

	// Defines configuration details about the data source for a batch load task.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `type:"structure" required:"true"`

	RecordVersion *int64 `type:"long"`

	// Report configuration for a batch load task. This contains details about where
	// error reports are stored.
	//
	// ReportConfiguration is a required field
	ReportConfiguration *ReportConfiguration `type:"structure" required:"true"`

	// Target Timestream database for a batch load task.
	//
	// TargetDatabaseName is a required field
	TargetDatabaseName *string `type:"string" required:"true"`

	// Target Timestream table for a batch load task.
	//
	// TargetTableName is a required field
	TargetTableName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchLoadTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchLoadTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchLoadTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchLoadTaskInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfiguration"))
	}
	if s.ReportConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportConfiguration"))
	}
	if s.TargetDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDatabaseName"))
	}
	if s.TargetTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTableName"))
	}
	if s.DataModelConfiguration != nil {
		if err := s.DataModelConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataModelConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceConfiguration != nil {
		if err := s.DataSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ReportConfiguration != nil {
		if err := s.ReportConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ReportConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateBatchLoadTaskInput) SetClientToken(v string) *CreateBatchLoadTaskInput {
	s.ClientToken = &v
	return s
}

// SetDataModelConfiguration sets the DataModelConfiguration field's value.
func (s *CreateBatchLoadTaskInput) SetDataModelConfiguration(v *DataModelConfiguration) *CreateBatchLoadTaskInput {
	s.DataModelConfiguration = v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *CreateBatchLoadTaskInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *CreateBatchLoadTaskInput {
	s.DataSourceConfiguration = v
	return s
}

// SetRecordVersion sets the RecordVersion field's value.
func (s *CreateBatchLoadTaskInput) SetRecordVersion(v int64) *CreateBatchLoadTaskInput {
	s.RecordVersion = &v
	return s
}

// SetReportConfiguration sets the ReportConfiguration field's value.
func (s *CreateBatchLoadTaskInput) SetReportConfiguration(v *ReportConfiguration) *CreateBatchLoadTaskInput {
	s.ReportConfiguration = v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *CreateBatchLoadTaskInput) SetTargetDatabaseName(v string) *CreateBatchLoadTaskInput {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetTableName sets the TargetTableName field's value.
func (s *CreateBatchLoadTaskInput) SetTargetTableName(v string) *CreateBatchLoadTaskInput {
	s.TargetTableName = &v
	return s
}

type CreateBatchLoadTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch load task.
	//
	// TaskId is a required field
	TaskId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchLoadTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchLoadTaskOutput) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *CreateBatchLoadTaskOutput) SetTaskId(v string) *CreateBatchLoadTaskOutput {
	s.TaskId = &v
	return s
}

type CreateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// The KMS key for the database. If the KMS key is not specified, the database
	// will be encrypted with a Timestream managed KMS key located in your account.
	// For more information, see Amazon Web Services managed keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
	KmsKeyId *string `min:"1" type:"string"`

	// A list of key-value pairs to label the table.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateDatabaseInput) SetDatabaseName(v string) *CreateDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDatabaseInput) SetKmsKeyId(v string) *CreateDatabaseInput {
	s.KmsKeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatabaseInput) SetTags(v []*Tag) *CreateDatabaseInput {
	s.Tags = v
	return s
}

type CreateDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The newly created Timestream database.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *CreateDatabaseOutput) SetDatabase(v *Database) *CreateDatabaseOutput {
	s.Database = v
	return s
}

type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// Contains properties to set on the table when enabling magnetic store writes.
	MagneticStoreWriteProperties *MagneticStoreWriteProperties `type:"structure"`

	// The duration for which your time-series data must be stored in the memory
	// store and the magnetic store.
	RetentionProperties *RetentionProperties `type:"structure"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`

	// A list of key-value pairs to label the table.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.MagneticStoreWriteProperties != nil {
		if err := s.MagneticStoreWriteProperties.Validate(); err != nil {
			invalidParams.AddNested("MagneticStoreWriteProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.RetentionProperties != nil {
		if err := s.RetentionProperties.Validate(); err != nil {
			invalidParams.AddNested("RetentionProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateTableInput) SetDatabaseName(v string) *CreateTableInput {
	s.DatabaseName = &v
	return s
}

// SetMagneticStoreWriteProperties sets the MagneticStoreWriteProperties field's value.
func (s *CreateTableInput) SetMagneticStoreWriteProperties(v *MagneticStoreWriteProperties) *CreateTableInput {
	s.MagneticStoreWriteProperties = v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *CreateTableInput) SetRetentionProperties(v *RetentionProperties) *CreateTableInput {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateTableInput) SetTableName(v string) *CreateTableInput {
	s.TableName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTableInput) SetTags(v []*Tag) *CreateTableInput {
	s.Tags = v
	return s
}

type CreateTableOutput struct {
	_ struct{} `type:"structure"`

	// The newly created Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *CreateTableOutput) SetTable(v *Table) *CreateTableOutput {
	s.Table = v
	return s
}

// A delimited data format where the column separator can be a comma and the
// record separator is a newline character.
type CsvConfiguration struct {
	_ struct{} `type:"structure"`

	// Column separator can be one of comma (','), pipe ('|), semicolon (';'), tab('/t'),
	// or blank space (' ').
	ColumnSeparator *string `min:"1" type:"string"`

	// Escape character can be one of
	EscapeChar *string `min:"1" type:"string"`

	// Can be blank space (' ').
	NullValue *string `min:"1" type:"string"`

	// Can be single quote (') or double quote (").
	QuoteChar *string `min:"1" type:"string"`

	// Specifies to trim leading and trailing white space.
	TrimWhiteSpace *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CsvConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CsvConfiguration"}
	if s.ColumnSeparator != nil && len(*s.ColumnSeparator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnSeparator", 1))
	}
	if s.EscapeChar != nil && len(*s.EscapeChar) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EscapeChar", 1))
	}
	if s.NullValue != nil && len(*s.NullValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NullValue", 1))
	}
	if s.QuoteChar != nil && len(*s.QuoteChar) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuoteChar", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnSeparator sets the ColumnSeparator field's value.
func (s *CsvConfiguration) SetColumnSeparator(v string) *CsvConfiguration {
	s.ColumnSeparator = &v
	return s
}

// SetEscapeChar sets the EscapeChar field's value.
func (s *CsvConfiguration) SetEscapeChar(v string) *CsvConfiguration {
	s.EscapeChar = &v
	return s
}

// SetNullValue sets the NullValue field's value.
func (s *CsvConfiguration) SetNullValue(v string) *CsvConfiguration {
	s.NullValue = &v
	return s
}

// SetQuoteChar sets the QuoteChar field's value.
func (s *CsvConfiguration) SetQuoteChar(v string) *CsvConfiguration {
	s.QuoteChar = &v
	return s
}

// SetTrimWhiteSpace sets the TrimWhiteSpace field's value.
func (s *CsvConfiguration) SetTrimWhiteSpace(v bool) *CsvConfiguration {
	s.TrimWhiteSpace = &v
	return s
}

// Data model for a batch load task.
type DataModel struct {
	_ struct{} `type:"structure"`

	// Source to target mappings for dimensions.
	//
	// DimensionMappings is a required field
	DimensionMappings []*DimensionMapping `min:"1" type:"list" required:"true"`

	MeasureNameColumn *string `min:"1" type:"string"`

	// Source to target mappings for measures.
	MixedMeasureMappings []*MixedMeasureMapping `min:"1" type:"list"`

	// Source to target mappings for multi-measure records.
	MultiMeasureMappings *MultiMeasureMappings `type:"structure"`

	// Source column to be mapped to time.
	TimeColumn *string `min:"1" type:"string"`

	// The granularity of the timestamp unit. It indicates if the time value is
	// in seconds, milliseconds, nanoseconds, or other supported values. Default
	// is MILLISECONDS.
	TimeUnit *string `type:"string" enum:"TimeUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataModel"}
	if s.DimensionMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionMappings"))
	}
	if s.DimensionMappings != nil && len(s.DimensionMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionMappings", 1))
	}
	if s.MeasureNameColumn != nil && len(*s.MeasureNameColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureNameColumn", 1))
	}
	if s.MixedMeasureMappings != nil && len(s.MixedMeasureMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MixedMeasureMappings", 1))
	}
	if s.TimeColumn != nil && len(*s.TimeColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeColumn", 1))
	}
	if s.DimensionMappings != nil {
		for i, v := range s.DimensionMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MixedMeasureMappings != nil {
		for i, v := range s.MixedMeasureMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MixedMeasureMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MultiMeasureMappings != nil {
		if err := s.MultiMeasureMappings.Validate(); err != nil {
			invalidParams.AddNested("MultiMeasureMappings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionMappings sets the DimensionMappings field's value.
func (s *DataModel) SetDimensionMappings(v []*DimensionMapping) *DataModel {
	s.DimensionMappings = v
	return s
}

// SetMeasureNameColumn sets the MeasureNameColumn field's value.
func (s *DataModel) SetMeasureNameColumn(v string) *DataModel {
	s.MeasureNameColumn = &v
	return s
}

// SetMixedMeasureMappings sets the MixedMeasureMappings field's value.
func (s *DataModel) SetMixedMeasureMappings(v []*MixedMeasureMapping) *DataModel {
	s.MixedMeasureMappings = v
	return s
}

// SetMultiMeasureMappings sets the MultiMeasureMappings field's value.
func (s *DataModel) SetMultiMeasureMappings(v *MultiMeasureMappings) *DataModel {
	s.MultiMeasureMappings = v
	return s
}

// SetTimeColumn sets the TimeColumn field's value.
func (s *DataModel) SetTimeColumn(v string) *DataModel {
	s.TimeColumn = &v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *DataModel) SetTimeUnit(v string) *DataModel {
	s.TimeUnit = &v
	return s
}

type DataModelConfiguration struct {
	_ struct{} `type:"structure"`

	// Data model for a batch load task.
	DataModel *DataModel `type:"structure"`

	DataModelS3Configuration *DataModelS3Configuration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModelConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataModelConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataModelConfiguration"}
	if s.DataModel != nil {
		if err := s.DataModel.Validate(); err != nil {
			invalidParams.AddNested("DataModel", err.(request.ErrInvalidParams))
		}
	}
	if s.DataModelS3Configuration != nil {
		if err := s.DataModelS3Configuration.Validate(); err != nil {
			invalidParams.AddNested("DataModelS3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataModel sets the DataModel field's value.
func (s *DataModelConfiguration) SetDataModel(v *DataModel) *DataModelConfiguration {
	s.DataModel = v
	return s
}

// SetDataModelS3Configuration sets the DataModelS3Configuration field's value.
func (s *DataModelConfiguration) SetDataModelS3Configuration(v *DataModelS3Configuration) *DataModelConfiguration {
	s.DataModelS3Configuration = v
	return s
}

type DataModelS3Configuration struct {
	_ struct{} `type:"structure"`

	BucketName *string `min:"3" type:"string"`

	ObjectKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModelS3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataModelS3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataModelS3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataModelS3Configuration"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.ObjectKey != nil && len(*s.ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *DataModelS3Configuration) SetBucketName(v string) *DataModelS3Configuration {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *DataModelS3Configuration) SetObjectKey(v string) *DataModelS3Configuration {
	s.ObjectKey = &v
	return s
}

// Defines configuration details about the data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// A delimited data format where the column separator can be a comma and the
	// record separator is a newline character.
	CsvConfiguration *CsvConfiguration `type:"structure"`

	// This is currently CSV.
	//
	// DataFormat is a required field
	DataFormat *string `type:"string" required:"true" enum:"BatchLoadDataFormat"`

	// Configuration of an S3 location for a file which contains data to load.
	//
	// DataSourceS3Configuration is a required field
	DataSourceS3Configuration *DataSourceS3Configuration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.DataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DataFormat"))
	}
	if s.DataSourceS3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceS3Configuration"))
	}
	if s.CsvConfiguration != nil {
		if err := s.CsvConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CsvConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceS3Configuration != nil {
		if err := s.DataSourceS3Configuration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceS3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvConfiguration sets the CsvConfiguration field's value.
func (s *DataSourceConfiguration) SetCsvConfiguration(v *CsvConfiguration) *DataSourceConfiguration {
	s.CsvConfiguration = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *DataSourceConfiguration) SetDataFormat(v string) *DataSourceConfiguration {
	s.DataFormat = &v
	return s
}

// SetDataSourceS3Configuration sets the DataSourceS3Configuration field's value.
func (s *DataSourceConfiguration) SetDataSourceS3Configuration(v *DataSourceS3Configuration) *DataSourceConfiguration {
	s.DataSourceS3Configuration = v
	return s
}

type DataSourceS3Configuration struct {
	_ struct{} `type:"structure"`

	// The bucket name of the customer S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	ObjectKeyPrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceS3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceS3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceS3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceS3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.ObjectKeyPrefix != nil && len(*s.ObjectKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *DataSourceS3Configuration) SetBucketName(v string) *DataSourceS3Configuration {
	s.BucketName = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *DataSourceS3Configuration) SetObjectKeyPrefix(v string) *DataSourceS3Configuration {
	s.ObjectKeyPrefix = &v
	return s
}

// A top-level container for a table. Databases and tables are the fundamental
// management concepts in Amazon Timestream. All tables in a database are encrypted
// with the same KMS key.
type Database struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that uniquely identifies this database.
	Arn *string `type:"string"`

	// The time when the database was created, calculated from the Unix epoch time.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Timestream database.
	DatabaseName *string `type:"string"`

	// The identifier of the KMS key used to encrypt the data stored in the database.
	KmsKeyId *string `min:"1" type:"string"`

	// The last time that this database was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The total number of tables found within a Timestream database.
	TableCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Database) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Database) SetArn(v string) *Database {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Database) SetCreationTime(v time.Time) *Database {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Database) SetDatabaseName(v string) *Database {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Database) SetKmsKeyId(v string) *Database {
	s.KmsKeyId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Database) SetLastUpdatedTime(v time.Time) *Database {
	s.LastUpdatedTime = &v
	return s
}

// SetTableCount sets the TableCount field's value.
func (s *Database) SetTableCount(v int64) *Database {
	s.TableCount = &v
	return s
}

type DeleteDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database to be deleted.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteDatabaseInput) SetDatabaseName(v string) *DeleteDatabaseInput {
	s.DatabaseName = &v
	return s
}

type DeleteDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatabaseOutput) GoString() string {
	return s.String()
}

type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the database where the Timestream database is to be deleted.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// The name of the Timestream table to be deleted.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteTableInput) SetDatabaseName(v string) *DeleteTableInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableInput) SetTableName(v string) *DeleteTableInput {
	s.TableName = &v
	return s
}

type DeleteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

type DescribeBatchLoadTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch load task.
	//
	// TaskId is a required field
	TaskId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchLoadTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchLoadTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBatchLoadTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBatchLoadTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeBatchLoadTaskInput) SetTaskId(v string) *DescribeBatchLoadTaskInput {
	s.TaskId = &v
	return s
}

type DescribeBatchLoadTaskOutput struct {
	_ struct{} `type:"structure"`

	// Description of the batch load task.
	//
	// BatchLoadTaskDescription is a required field
	BatchLoadTaskDescription *BatchLoadTaskDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchLoadTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchLoadTaskOutput) GoString() string {
	return s.String()
}

// SetBatchLoadTaskDescription sets the BatchLoadTaskDescription field's value.
func (s *DescribeBatchLoadTaskOutput) SetBatchLoadTaskDescription(v *BatchLoadTaskDescription) *DescribeBatchLoadTaskOutput {
	s.BatchLoadTaskDescription = v
	return s
}

type DescribeDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DescribeDatabaseInput) SetDatabaseName(v string) *DescribeDatabaseInput {
	s.DatabaseName = &v
	return s
}

type DescribeDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream table.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *DescribeDatabaseOutput) SetDatabase(v *Database) *DescribeDatabaseOutput {
	s.Database = v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// An Endpoints object is returned when a DescribeEndpoints request is made.
	//
	// Endpoints is a required field
	Endpoints []*Endpoint `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DescribeTableInput) SetDatabaseName(v string) *DescribeTableInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableInput) SetTableName(v string) *DescribeTableInput {
	s.TableName = &v
	return s
}

type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// The Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *DescribeTableOutput) SetTable(v *Table) *DescribeTableOutput {
	s.Table = v
	return s
}

// Represents the metadata attributes of the time series. For example, the name
// and Availability Zone of an EC2 instance or the name of the manufacturer
// of a wind turbine are dimensions.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The data type of the dimension for the time-series data point.
	DimensionValueType *string `type:"string" enum:"DimensionValueType"`

	// Dimension represents the metadata attributes of the time series. For example,
	// the name and Availability Zone of an EC2 instance or the name of the manufacturer
	// of a wind turbine are dimensions.
	//
	// For constraints on dimension names, see Naming Constraints (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionValueType sets the DimensionValueType field's value.
func (s *Dimension) SetDimensionValueType(v string) *Dimension {
	s.DimensionValueType = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

type DimensionMapping struct {
	_ struct{} `type:"structure"`

	DestinationColumn *string `min:"1" type:"string"`

	SourceColumn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionMapping"}
	if s.DestinationColumn != nil && len(*s.DestinationColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationColumn", 1))
	}
	if s.SourceColumn != nil && len(*s.SourceColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceColumn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationColumn sets the DestinationColumn field's value.
func (s *DimensionMapping) SetDestinationColumn(v string) *DimensionMapping {
	s.DestinationColumn = &v
	return s
}

// SetSourceColumn sets the SourceColumn field's value.
func (s *DimensionMapping) SetSourceColumn(v string) *DimensionMapping {
	s.SourceColumn = &v
	return s
}

// Represents an available endpoint against which to make API calls against,
// as well as the TTL for that endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// An endpoint address.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// The TTL for the endpoint, in minutes.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetCachePeriodInMinutes sets the CachePeriodInMinutes field's value.
func (s *Endpoint) SetCachePeriodInMinutes(v int64) *Endpoint {
	s.CachePeriodInMinutes = &v
	return s
}

// Timestream was unable to fully process this request because of an internal
// server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested endpoint was not valid.
type InvalidEndpointException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) GoString() string {
	return s.String()
}

func newErrorInvalidEndpointException(v protocol.ResponseMetadata) error {
	return &InvalidEndpointException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEndpointException) Code() string {
	return "InvalidEndpointException"
}

// Message returns the exception's message.
func (s *InvalidEndpointException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEndpointException) OrigErr() error {
	return nil
}

func (s *InvalidEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEndpointException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEndpointException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBatchLoadTasksInput struct {
	_ struct{} `type:"structure"`

	// The total number of items to return in the output. If the total number of
	// items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `type:"string"`

	// Status of the batch load task.
	TaskStatus *string `type:"string" enum:"BatchLoadStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchLoadTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchLoadTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchLoadTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBatchLoadTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBatchLoadTasksInput) SetMaxResults(v int64) *ListBatchLoadTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchLoadTasksInput) SetNextToken(v string) *ListBatchLoadTasksInput {
	s.NextToken = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *ListBatchLoadTasksInput) SetTaskStatus(v string) *ListBatchLoadTasksInput {
	s.TaskStatus = &v
	return s
}

type ListBatchLoadTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of batch load task details.
	BatchLoadTasks []*BatchLoadTask `type:"list"`

	// A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchLoadTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchLoadTasksOutput) GoString() string {
	return s.String()
}

// SetBatchLoadTasks sets the BatchLoadTasks field's value.
func (s *ListBatchLoadTasksOutput) SetBatchLoadTasks(v []*BatchLoadTask) *ListBatchLoadTasksOutput {
	s.BatchLoadTasks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchLoadTasksOutput) SetNextToken(v string) *ListBatchLoadTasksOutput {
	s.NextToken = &v
	return s
}

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The total number of items to return in the output. If the total number of
	// items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatabasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatabasesInput) SetMaxResults(v int64) *ListDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesInput) SetNextToken(v string) *ListDatabasesInput {
	s.NextToken = &v
	return s
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of database names.
	Databases []*Database `type:"list"`

	// The pagination token. This parameter is returned when the response is truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabases sets the Databases field's value.
func (s *ListDatabasesOutput) SetDatabases(v []*Database) *ListDatabasesOutput {
	s.Databases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesOutput) SetNextToken(v string) *ListDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	DatabaseName *string `type:"string"`

	// The total number of items to return in the output. If the total number of
	// items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListTablesInput) SetDatabaseName(v string) *ListTablesInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `type:"string"`

	// A list of tables.
	Tables []*Table `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*Table) *ListTablesOutput {
	s.Tables = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Timestream resource with tags to be listed. This value is an Amazon Resource
	// Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags currently associated with the Timestream resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The location to write error reports for records rejected, asynchronously,
// during magnetic store writes.
type MagneticStoreRejectedDataLocation struct {
	_ struct{} `type:"structure"`

	// Configuration of an S3 location to write error reports for records rejected,
	// asynchronously, during magnetic store writes.
	S3Configuration *S3Configuration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MagneticStoreRejectedDataLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MagneticStoreRejectedDataLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MagneticStoreRejectedDataLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MagneticStoreRejectedDataLocation"}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *MagneticStoreRejectedDataLocation) SetS3Configuration(v *S3Configuration) *MagneticStoreRejectedDataLocation {
	s.S3Configuration = v
	return s
}

// The set of properties on a table for configuring magnetic store writes.
type MagneticStoreWriteProperties struct {
	_ struct{} `type:"structure"`

	// A flag to enable magnetic store writes.
	//
	// EnableMagneticStoreWrites is a required field
	EnableMagneticStoreWrites *bool `type:"boolean" required:"true"`

	// The location to write error reports for records rejected asynchronously during
	// magnetic store writes.
	MagneticStoreRejectedDataLocation *MagneticStoreRejectedDataLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MagneticStoreWriteProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MagneticStoreWriteProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MagneticStoreWriteProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MagneticStoreWriteProperties"}
	if s.EnableMagneticStoreWrites == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableMagneticStoreWrites"))
	}
	if s.MagneticStoreRejectedDataLocation != nil {
		if err := s.MagneticStoreRejectedDataLocation.Validate(); err != nil {
			invalidParams.AddNested("MagneticStoreRejectedDataLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableMagneticStoreWrites sets the EnableMagneticStoreWrites field's value.
func (s *MagneticStoreWriteProperties) SetEnableMagneticStoreWrites(v bool) *MagneticStoreWriteProperties {
	s.EnableMagneticStoreWrites = &v
	return s
}

// SetMagneticStoreRejectedDataLocation sets the MagneticStoreRejectedDataLocation field's value.
func (s *MagneticStoreWriteProperties) SetMagneticStoreRejectedDataLocation(v *MagneticStoreRejectedDataLocation) *MagneticStoreWriteProperties {
	s.MagneticStoreRejectedDataLocation = v
	return s
}

// Represents the data attribute of the time series. For example, the CPU utilization
// of an EC2 instance or the RPM of a wind turbine are measures. MeasureValue
// has both name and value.
//
// MeasureValue is only allowed for type MULTI. Using MULTI type, you can pass
// multiple data attributes associated with the same time series in a single
// record
type MeasureValue struct {
	_ struct{} `type:"structure"`

	// The name of the MeasureValue.
	//
	// For constraints on MeasureValue names, see Naming Constraints (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming)
	// in the Amazon Timestream Developer Guide.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Contains the data type of the MeasureValue for the time-series data point.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"MeasureValueType"`

	// The value for the MeasureValue.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeasureValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeasureValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeasureValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeasureValue"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MeasureValue) SetName(v string) *MeasureValue {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *MeasureValue) SetType(v string) *MeasureValue {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MeasureValue) SetValue(v string) *MeasureValue {
	s.Value = &v
	return s
}

type MixedMeasureMapping struct {
	_ struct{} `type:"structure"`

	MeasureName *string `min:"1" type:"string"`

	// MeasureValueType is a required field
	MeasureValueType *string `type:"string" required:"true" enum:"MeasureValueType"`

	MultiMeasureAttributeMappings []*MultiMeasureAttributeMapping `min:"1" type:"list"`

	SourceColumn *string `min:"1" type:"string"`

	TargetMeasureName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedMeasureMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedMeasureMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MixedMeasureMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MixedMeasureMapping"}
	if s.MeasureName != nil && len(*s.MeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureName", 1))
	}
	if s.MeasureValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValueType"))
	}
	if s.MultiMeasureAttributeMappings != nil && len(s.MultiMeasureAttributeMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeMappings", 1))
	}
	if s.SourceColumn != nil && len(*s.SourceColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceColumn", 1))
	}
	if s.TargetMeasureName != nil && len(*s.TargetMeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetMeasureName", 1))
	}
	if s.MultiMeasureAttributeMappings != nil {
		for i, v := range s.MultiMeasureAttributeMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureAttributeMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureName sets the MeasureName field's value.
func (s *MixedMeasureMapping) SetMeasureName(v string) *MixedMeasureMapping {
	s.MeasureName = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *MixedMeasureMapping) SetMeasureValueType(v string) *MixedMeasureMapping {
	s.MeasureValueType = &v
	return s
}

// SetMultiMeasureAttributeMappings sets the MultiMeasureAttributeMappings field's value.
func (s *MixedMeasureMapping) SetMultiMeasureAttributeMappings(v []*MultiMeasureAttributeMapping) *MixedMeasureMapping {
	s.MultiMeasureAttributeMappings = v
	return s
}

// SetSourceColumn sets the SourceColumn field's value.
func (s *MixedMeasureMapping) SetSourceColumn(v string) *MixedMeasureMapping {
	s.SourceColumn = &v
	return s
}

// SetTargetMeasureName sets the TargetMeasureName field's value.
func (s *MixedMeasureMapping) SetTargetMeasureName(v string) *MixedMeasureMapping {
	s.TargetMeasureName = &v
	return s
}

type MultiMeasureAttributeMapping struct {
	_ struct{} `type:"structure"`

	MeasureValueType *string `type:"string" enum:"ScalarMeasureValueType"`

	// SourceColumn is a required field
	SourceColumn *string `min:"1" type:"string" required:"true"`

	TargetMultiMeasureAttributeName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureAttributeMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureAttributeMapping"}
	if s.SourceColumn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceColumn"))
	}
	if s.SourceColumn != nil && len(*s.SourceColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceColumn", 1))
	}
	if s.TargetMultiMeasureAttributeName != nil && len(*s.TargetMultiMeasureAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetMultiMeasureAttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *MultiMeasureAttributeMapping) SetMeasureValueType(v string) *MultiMeasureAttributeMapping {
	s.MeasureValueType = &v
	return s
}

// SetSourceColumn sets the SourceColumn field's value.
func (s *MultiMeasureAttributeMapping) SetSourceColumn(v string) *MultiMeasureAttributeMapping {
	s.SourceColumn = &v
	return s
}

// SetTargetMultiMeasureAttributeName sets the TargetMultiMeasureAttributeName field's value.
func (s *MultiMeasureAttributeMapping) SetTargetMultiMeasureAttributeName(v string) *MultiMeasureAttributeMapping {
	s.TargetMultiMeasureAttributeName = &v
	return s
}

type MultiMeasureMappings struct {
	_ struct{} `type:"structure"`

	// MultiMeasureAttributeMappings is a required field
	MultiMeasureAttributeMappings []*MultiMeasureAttributeMapping `min:"1" type:"list" required:"true"`

	TargetMultiMeasureName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMappings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMappings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureMappings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureMappings"}
	if s.MultiMeasureAttributeMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiMeasureAttributeMappings"))
	}
	if s.MultiMeasureAttributeMappings != nil && len(s.MultiMeasureAttributeMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeMappings", 1))
	}
	if s.TargetMultiMeasureName != nil && len(*s.TargetMultiMeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetMultiMeasureName", 1))
	}
	if s.MultiMeasureAttributeMappings != nil {
		for i, v := range s.MultiMeasureAttributeMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureAttributeMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiMeasureAttributeMappings sets the MultiMeasureAttributeMappings field's value.
func (s *MultiMeasureMappings) SetMultiMeasureAttributeMappings(v []*MultiMeasureAttributeMapping) *MultiMeasureMappings {
	s.MultiMeasureAttributeMappings = v
	return s
}

// SetTargetMultiMeasureName sets the TargetMultiMeasureName field's value.
func (s *MultiMeasureMappings) SetTargetMultiMeasureName(v string) *MultiMeasureMappings {
	s.TargetMultiMeasureName = &v
	return s
}

// Represents a time-series data point being written into Timestream. Each record
// contains an array of dimensions. Dimensions represent the metadata attributes
// of a time-series data point, such as the instance name or Availability Zone
// of an EC2 instance. A record also contains the measure name, which is the
// name of the measure being collected (for example, the CPU utilization of
// an EC2 instance). Additionally, a record contains the measure value and the
// value type, which is the data type of the measure value. Also, the record
// contains the timestamp of when the measure was collected and the timestamp
// unit, which represents the granularity of the timestamp.
//
// Records have a Version field, which is a 64-bit long that you can use for
// updating data points. Writes of a duplicate record with the same dimension,
// timestamp, and measure name but different measure value will only succeed
// if the Version attribute of the record in the write request is higher than
// that of the existing record. Timestream defaults to a Version of 1 for records
// without the Version field.
type Record struct {
	_ struct{} `type:"structure"`

	// Contains the list of dimensions for time-series data points.
	Dimensions []*Dimension `type:"list"`

	// Measure represents the data attribute of the time series. For example, the
	// CPU utilization of an EC2 instance or the RPM of a wind turbine are measures.
	MeasureName *string `min:"1" type:"string"`

	// Contains the measure value for the time-series data point.
	MeasureValue *string `min:"1" type:"string"`

	// Contains the data type of the measure value for the time-series data point.
	// Default type is DOUBLE.
	MeasureValueType *string `type:"string" enum:"MeasureValueType"`

	// Contains the list of MeasureValue for time-series data points.
	//
	// This is only allowed for type MULTI. For scalar values, use MeasureValue
	// attribute of the record directly.
	MeasureValues []*MeasureValue `type:"list"`

	// Contains the time at which the measure value for the data point was collected.
	// The time value plus the unit provides the time elapsed since the epoch. For
	// example, if the time value is 12345 and the unit is ms, then 12345 ms have
	// elapsed since the epoch.
	Time *string `min:"1" type:"string"`

	// The granularity of the timestamp unit. It indicates if the time value is
	// in seconds, milliseconds, nanoseconds, or other supported values. Default
	// is MILLISECONDS.
	TimeUnit *string `type:"string" enum:"TimeUnit"`

	// 64-bit attribute used for record updates. Write requests for duplicate data
	// with a higher version number will update the existing measure value and version.
	// In cases where the measure value is the same, Version will still be updated.
	// Default value is 1.
	//
	// Version must be 1 or greater, or you will receive a ValidationException error.
	Version *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Record) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Record"}
	if s.MeasureName != nil && len(*s.MeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureName", 1))
	}
	if s.MeasureValue != nil && len(*s.MeasureValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureValue", 1))
	}
	if s.Time != nil && len(*s.Time) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Time", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MeasureValues != nil {
		for i, v := range s.MeasureValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MeasureValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Record) SetDimensions(v []*Dimension) *Record {
	s.Dimensions = v
	return s
}

// SetMeasureName sets the MeasureName field's value.
func (s *Record) SetMeasureName(v string) *Record {
	s.MeasureName = &v
	return s
}

// SetMeasureValue sets the MeasureValue field's value.
func (s *Record) SetMeasureValue(v string) *Record {
	s.MeasureValue = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *Record) SetMeasureValueType(v string) *Record {
	s.MeasureValueType = &v
	return s
}

// SetMeasureValues sets the MeasureValues field's value.
func (s *Record) SetMeasureValues(v []*MeasureValue) *Record {
	s.MeasureValues = v
	return s
}

// SetTime sets the Time field's value.
func (s *Record) SetTime(v string) *Record {
	s.Time = &v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *Record) SetTimeUnit(v string) *Record {
	s.TimeUnit = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Record) SetVersion(v int64) *Record {
	s.Version = &v
	return s
}

// Information on the records ingested by this request.
type RecordsIngested struct {
	_ struct{} `type:"structure"`

	// Count of records ingested into the magnetic store.
	MagneticStore *int64 `type:"integer"`

	// Count of records ingested into the memory store.
	MemoryStore *int64 `type:"integer"`

	// Total count of successfully ingested records.
	Total *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordsIngested) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordsIngested) GoString() string {
	return s.String()
}

// SetMagneticStore sets the MagneticStore field's value.
func (s *RecordsIngested) SetMagneticStore(v int64) *RecordsIngested {
	s.MagneticStore = &v
	return s
}

// SetMemoryStore sets the MemoryStore field's value.
func (s *RecordsIngested) SetMemoryStore(v int64) *RecordsIngested {
	s.MemoryStore = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *RecordsIngested) SetTotal(v int64) *RecordsIngested {
	s.Total = &v
	return s
}

// Represents records that were not successfully inserted into Timestream due
// to data validation issues that must be resolved before reinserting time-series
// data into the system.
type RejectedRecord struct {
	_ struct{} `type:"structure"`

	// The existing version of the record. This value is populated in scenarios
	// where an identical record exists with a higher version than the version in
	// the write request.
	ExistingVersion *int64 `type:"long"`

	// The reason why a record was not successfully inserted into Timestream. Possible
	// causes of failure include:
	//
	//    * Records with duplicate data where there are multiple records with the
	//    same dimensions, timestamps, and measure names but: Measure values are
	//    different Version is not present in the request, or the value of version
	//    in the new record is equal to or lower than the existing value If Timestream
	//    rejects data for this case, the ExistingVersion field in the RejectedRecords
	//    response will indicate the current record’s version. To force an update,
	//    you can resend the request with a version for the record set to a value
	//    greater than the ExistingVersion.
	//
	//    * Records with timestamps that lie outside the retention duration of the
	//    memory store. When the retention window is updated, you will receive a
	//    RejectedRecords exception if you immediately try to ingest data within
	//    the new window. To avoid a RejectedRecords exception, wait until the duration
	//    of the new window to ingest new data. For further information, see Best
	//    Practices for Configuring Timestream (https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration)
	//    and the explanation of how storage works in Timestream (https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html).
	//
	//    * Records with dimensions or measures that exceed the Timestream defined
	//    limits.
	//
	// For more information, see Access Management (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
	// in the Timestream Developer Guide.
	Reason *string `type:"string"`

	// The index of the record in the input request for WriteRecords. Indexes begin
	// with 0.
	RecordIndex *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecord) GoString() string {
	return s.String()
}

// SetExistingVersion sets the ExistingVersion field's value.
func (s *RejectedRecord) SetExistingVersion(v int64) *RejectedRecord {
	s.ExistingVersion = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RejectedRecord) SetReason(v string) *RejectedRecord {
	s.Reason = &v
	return s
}

// SetRecordIndex sets the RecordIndex field's value.
func (s *RejectedRecord) SetRecordIndex(v int64) *RejectedRecord {
	s.RecordIndex = &v
	return s
}

// WriteRecords would throw this exception in the following cases:
//
//   - Records with duplicate data where there are multiple records with the
//     same dimensions, timestamps, and measure names but: Measure values are
//     different Version is not present in the request or the value of version
//     in the new record is equal to or lower than the existing value In this
//     case, if Timestream rejects data, the ExistingVersion field in the RejectedRecords
//     response will indicate the current record’s version. To force an update,
//     you can resend the request with a version for the record set to a value
//     greater than the ExistingVersion.
//
//   - Records with timestamps that lie outside the retention duration of the
//     memory store.
//
//   - Records with dimensions or measures that exceed the Timestream defined
//     limits.
//
// For more information, see Quotas (https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
// in the Amazon Timestream Developer Guide.
type RejectedRecordsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RejectedRecords []*RejectedRecord `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecordsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectedRecordsException) GoString() string {
	return s.String()
}

func newErrorRejectedRecordsException(v protocol.ResponseMetadata) error {
	return &RejectedRecordsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RejectedRecordsException) Code() string {
	return "RejectedRecordsException"
}

// Message returns the exception's message.
func (s *RejectedRecordsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RejectedRecordsException) OrigErr() error {
	return nil
}

func (s *RejectedRecordsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RejectedRecordsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RejectedRecordsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Report configuration for a batch load task. This contains details about where
// error reports are stored.
type ReportConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration of an S3 location to write error reports and events for a batch
	// load.
	ReportS3Configuration *ReportS3Configuration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportConfiguration"}
	if s.ReportS3Configuration != nil {
		if err := s.ReportS3Configuration.Validate(); err != nil {
			invalidParams.AddNested("ReportS3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportS3Configuration sets the ReportS3Configuration field's value.
func (s *ReportConfiguration) SetReportS3Configuration(v *ReportS3Configuration) *ReportConfiguration {
	s.ReportS3Configuration = v
	return s
}

type ReportS3Configuration struct {
	_ struct{} `type:"structure"`

	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	EncryptionOption *string `type:"string" enum:"S3EncryptionOption"`

	KmsKeyId *string `min:"1" type:"string"`

	ObjectKeyPrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportS3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportS3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportS3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportS3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.ObjectKeyPrefix != nil && len(*s.ObjectKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *ReportS3Configuration) SetBucketName(v string) *ReportS3Configuration {
	s.BucketName = &v
	return s
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *ReportS3Configuration) SetEncryptionOption(v string) *ReportS3Configuration {
	s.EncryptionOption = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReportS3Configuration) SetKmsKeyId(v string) *ReportS3Configuration {
	s.KmsKeyId = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *ReportS3Configuration) SetObjectKeyPrefix(v string) *ReportS3Configuration {
	s.ObjectKeyPrefix = &v
	return s
}

// The operation tried to access a nonexistent resource. The resource might
// not be specified correctly, or its status might not be ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResumeBatchLoadTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the batch load task to resume.
	//
	// TaskId is a required field
	TaskId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeBatchLoadTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeBatchLoadTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResumeBatchLoadTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResumeBatchLoadTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *ResumeBatchLoadTaskInput) SetTaskId(v string) *ResumeBatchLoadTaskInput {
	s.TaskId = &v
	return s
}

type ResumeBatchLoadTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeBatchLoadTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeBatchLoadTaskOutput) GoString() string {
	return s.String()
}

// Retention properties contain the duration for which your time-series data
// must be stored in the magnetic store and the memory store.
type RetentionProperties struct {
	_ struct{} `type:"structure"`

	// The duration for which data must be stored in the magnetic store.
	//
	// MagneticStoreRetentionPeriodInDays is a required field
	MagneticStoreRetentionPeriodInDays *int64 `min:"1" type:"long" required:"true"`

	// The duration for which data must be stored in the memory store.
	//
	// MemoryStoreRetentionPeriodInHours is a required field
	MemoryStoreRetentionPeriodInHours *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionProperties"}
	if s.MagneticStoreRetentionPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("MagneticStoreRetentionPeriodInDays"))
	}
	if s.MagneticStoreRetentionPeriodInDays != nil && *s.MagneticStoreRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MagneticStoreRetentionPeriodInDays", 1))
	}
	if s.MemoryStoreRetentionPeriodInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("MemoryStoreRetentionPeriodInHours"))
	}
	if s.MemoryStoreRetentionPeriodInHours != nil && *s.MemoryStoreRetentionPeriodInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MemoryStoreRetentionPeriodInHours", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMagneticStoreRetentionPeriodInDays sets the MagneticStoreRetentionPeriodInDays field's value.
func (s *RetentionProperties) SetMagneticStoreRetentionPeriodInDays(v int64) *RetentionProperties {
	s.MagneticStoreRetentionPeriodInDays = &v
	return s
}

// SetMemoryStoreRetentionPeriodInHours sets the MemoryStoreRetentionPeriodInHours field's value.
func (s *RetentionProperties) SetMemoryStoreRetentionPeriodInHours(v int64) *RetentionProperties {
	s.MemoryStoreRetentionPeriodInHours = &v
	return s
}

// The configuration that specifies an S3 location.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// The bucket name of the customer S3 bucket.
	BucketName *string `min:"3" type:"string"`

	// The encryption option for the customer S3 location. Options are S3 server-side
	// encryption with an S3 managed key or Amazon Web Services managed key.
	EncryptionOption *string `type:"string" enum:"S3EncryptionOption"`

	// The KMS key ID for the customer S3 location when encrypting with an Amazon
	// Web Services managed key.
	KmsKeyId *string `min:"1" type:"string"`

	// The object key preview for the customer S3 location.
	ObjectKeyPrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.ObjectKeyPrefix != nil && len(*s.ObjectKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Configuration) SetBucketName(v string) *S3Configuration {
	s.BucketName = &v
	return s
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *S3Configuration) SetEncryptionOption(v string) *S3Configuration {
	s.EncryptionOption = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *S3Configuration) SetKmsKeyId(v string) *S3Configuration {
	s.KmsKeyId = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *S3Configuration) SetObjectKeyPrefix(v string) *S3Configuration {
	s.ObjectKeyPrefix = &v
	return s
}

// The instance quota of resource exceeded for this account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a database table in Timestream. Tables contain one or more related
// time series. You can modify the retention duration of the memory store and
// the magnetic store for a table.
type Table struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that uniquely identifies this table.
	Arn *string `type:"string"`

	// The time when the Timestream table was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Timestream database that contains this table.
	DatabaseName *string `type:"string"`

	// The time when the Timestream table was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Contains properties to set on the table when enabling magnetic store writes.
	MagneticStoreWriteProperties *MagneticStoreWriteProperties `type:"structure"`

	// The retention duration for the memory store and magnetic store.
	RetentionProperties *RetentionProperties `type:"structure"`

	// The name of the Timestream table.
	TableName *string `type:"string"`

	// The current state of the table:
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	TableStatus *string `type:"string" enum:"TableStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Table) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Table) SetArn(v string) *Table {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Table) SetCreationTime(v time.Time) *Table {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Table) SetDatabaseName(v string) *Table {
	s.DatabaseName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Table) SetLastUpdatedTime(v time.Time) *Table {
	s.LastUpdatedTime = &v
	return s
}

// SetMagneticStoreWriteProperties sets the MagneticStoreWriteProperties field's value.
func (s *Table) SetMagneticStoreWriteProperties(v *MagneticStoreWriteProperties) *Table {
	s.MagneticStoreWriteProperties = v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *Table) SetRetentionProperties(v *RetentionProperties) *Table {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Table) SetTableName(v string) *Table {
	s.TableName = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *Table) SetTableStatus(v string) *Table {
	s.TableStatus = &v
	return s
}

// A tag is a label that you assign to a Timestream database and/or table. Each
// tag consists of a key and an optional value, both of which you define. With
// tags, you can categorize databases and/or tables, for example, by purpose,
// owner, or environment.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Timestream resource to which tags should be added. This value
	// is an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Timestream resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Too many requests were made by a user and they exceeded the service quotas.
// The request was throttled.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Timestream resource that the tags will be removed from. This value is
	// an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags keys. Existing tags of the resource whose keys are members
	// of this list will be removed from the Timestream resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// The identifier of the new KMS key (KmsKeyId) to be used to encrypt the data
	// stored in the database. If the KmsKeyId currently registered with the database
	// is the same as the KmsKeyId in the request, there will not be any update.
	//
	// You can specify the KmsKeyId using any of the following:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-1:111122223333:alias/ExampleAlias
	//
	// KmsKeyId is a required field
	KmsKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateDatabaseInput) SetDatabaseName(v string) *UpdateDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateDatabaseInput) SetKmsKeyId(v string) *UpdateDatabaseInput {
	s.KmsKeyId = &v
	return s
}

type UpdateDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// A top-level container for a table. Databases and tables are the fundamental
	// management concepts in Amazon Timestream. All tables in a database are encrypted
	// with the same KMS key.
	Database *Database `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *UpdateDatabaseOutput) SetDatabase(v *Database) *UpdateDatabaseOutput {
	s.Database = v
	return s
}

type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// Contains properties to set on the table when enabling magnetic store writes.
	MagneticStoreWriteProperties *MagneticStoreWriteProperties `type:"structure"`

	// The retention duration of the memory store and the magnetic store.
	RetentionProperties *RetentionProperties `type:"structure"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.MagneticStoreWriteProperties != nil {
		if err := s.MagneticStoreWriteProperties.Validate(); err != nil {
			invalidParams.AddNested("MagneticStoreWriteProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.RetentionProperties != nil {
		if err := s.RetentionProperties.Validate(); err != nil {
			invalidParams.AddNested("RetentionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateTableInput) SetDatabaseName(v string) *UpdateTableInput {
	s.DatabaseName = &v
	return s
}

// SetMagneticStoreWriteProperties sets the MagneticStoreWriteProperties field's value.
func (s *UpdateTableInput) SetMagneticStoreWriteProperties(v *MagneticStoreWriteProperties) *UpdateTableInput {
	s.MagneticStoreWriteProperties = v
	return s
}

// SetRetentionProperties sets the RetentionProperties field's value.
func (s *UpdateTableInput) SetRetentionProperties(v *RetentionProperties) *UpdateTableInput {
	s.RetentionProperties = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableInput) SetTableName(v string) *UpdateTableInput {
	s.TableName = &v
	return s
}

type UpdateTableOutput struct {
	_ struct{} `type:"structure"`

	// The updated Timestream table.
	Table *Table `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *UpdateTableOutput) SetTable(v *Table) *UpdateTableOutput {
	s.Table = v
	return s
}

// An invalid or malformed request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type WriteRecordsInput struct {
	_ struct{} `type:"structure"`

	// A record that contains the common measure, dimension, time, and version attributes
	// shared across all the records in the request. The measure and dimension attributes
	// specified will be merged with the measure and dimension attributes in the
	// records object when the data is written into Timestream. Dimensions may not
	// overlap, or a ValidationException will be thrown. In other words, a record
	// must contain dimensions with unique names.
	CommonAttributes *Record `type:"structure"`

	// The name of the Timestream database.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// An array of records that contain the unique measure, dimension, time, and
	// version attributes for each time-series data point.
	//
	// Records is a required field
	Records []*Record `min:"1" type:"list" required:"true"`

	// The name of the Timestream table.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteRecordsInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.CommonAttributes != nil {
		if err := s.CommonAttributes.Validate(); err != nil {
			invalidParams.AddNested("CommonAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonAttributes sets the CommonAttributes field's value.
func (s *WriteRecordsInput) SetCommonAttributes(v *Record) *WriteRecordsInput {
	s.CommonAttributes = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *WriteRecordsInput) SetDatabaseName(v string) *WriteRecordsInput {
	s.DatabaseName = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *WriteRecordsInput) SetRecords(v []*Record) *WriteRecordsInput {
	s.Records = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *WriteRecordsInput) SetTableName(v string) *WriteRecordsInput {
	s.TableName = &v
	return s
}

type WriteRecordsOutput struct {
	_ struct{} `type:"structure"`

	// Information on the records ingested by this request.
	RecordsIngested *RecordsIngested `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteRecordsOutput) GoString() string {
	return s.String()
}

// SetRecordsIngested sets the RecordsIngested field's value.
func (s *WriteRecordsOutput) SetRecordsIngested(v *RecordsIngested) *WriteRecordsOutput {
	s.RecordsIngested = v
	return s
}

const (
	// BatchLoadDataFormatCsv is a BatchLoadDataFormat enum value
	BatchLoadDataFormatCsv = "CSV"
)

// BatchLoadDataFormat_Values returns all elements of the BatchLoadDataFormat enum
func BatchLoadDataFormat_Values() []string {
	return []string{
		BatchLoadDataFormatCsv,
	}
}

const (
	// BatchLoadStatusCreated is a BatchLoadStatus enum value
	BatchLoadStatusCreated = "CREATED"

	// BatchLoadStatusInProgress is a BatchLoadStatus enum value
	BatchLoadStatusInProgress = "IN_PROGRESS"

	// BatchLoadStatusFailed is a BatchLoadStatus enum value
	BatchLoadStatusFailed = "FAILED"

	// BatchLoadStatusSucceeded is a BatchLoadStatus enum value
	BatchLoadStatusSucceeded = "SUCCEEDED"

	// BatchLoadStatusProgressStopped is a BatchLoadStatus enum value
	BatchLoadStatusProgressStopped = "PROGRESS_STOPPED"

	// BatchLoadStatusPendingResume is a BatchLoadStatus enum value
	BatchLoadStatusPendingResume = "PENDING_RESUME"
)

// BatchLoadStatus_Values returns all elements of the BatchLoadStatus enum
func BatchLoadStatus_Values() []string {
	return []string{
		BatchLoadStatusCreated,
		BatchLoadStatusInProgress,
		BatchLoadStatusFailed,
		BatchLoadStatusSucceeded,
		BatchLoadStatusProgressStopped,
		BatchLoadStatusPendingResume,
	}
}

const (
	// DimensionValueTypeVarchar is a DimensionValueType enum value
	DimensionValueTypeVarchar = "VARCHAR"
)

// DimensionValueType_Values returns all elements of the DimensionValueType enum
func DimensionValueType_Values() []string {
	return []string{
		DimensionValueTypeVarchar,
	}
}

const (
	// MeasureValueTypeDouble is a MeasureValueType enum value
	MeasureValueTypeDouble = "DOUBLE"

	// MeasureValueTypeBigint is a MeasureValueType enum value
	MeasureValueTypeBigint = "BIGINT"

	// MeasureValueTypeVarchar is a MeasureValueType enum value
	MeasureValueTypeVarchar = "VARCHAR"

	// MeasureValueTypeBoolean is a MeasureValueType enum value
	MeasureValueTypeBoolean = "BOOLEAN"

	// MeasureValueTypeTimestamp is a MeasureValueType enum value
	MeasureValueTypeTimestamp = "TIMESTAMP"

	// MeasureValueTypeMulti is a MeasureValueType enum value
	MeasureValueTypeMulti = "MULTI"
)

// MeasureValueType_Values returns all elements of the MeasureValueType enum
func MeasureValueType_Values() []string {
	return []string{
		MeasureValueTypeDouble,
		MeasureValueTypeBigint,
		MeasureValueTypeVarchar,
		MeasureValueTypeBoolean,
		MeasureValueTypeTimestamp,
		MeasureValueTypeMulti,
	}
}

const (
	// S3EncryptionOptionSseS3 is a S3EncryptionOption enum value
	S3EncryptionOptionSseS3 = "SSE_S3"

	// S3EncryptionOptionSseKms is a S3EncryptionOption enum value
	S3EncryptionOptionSseKms = "SSE_KMS"
)

// S3EncryptionOption_Values returns all elements of the S3EncryptionOption enum
func S3EncryptionOption_Values() []string {
	return []string{
		S3EncryptionOptionSseS3,
		S3EncryptionOptionSseKms,
	}
}

const (
	// ScalarMeasureValueTypeDouble is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeDouble = "DOUBLE"

	// ScalarMeasureValueTypeBigint is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeBigint = "BIGINT"

	// ScalarMeasureValueTypeBoolean is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeBoolean = "BOOLEAN"

	// ScalarMeasureValueTypeVarchar is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeVarchar = "VARCHAR"

	// ScalarMeasureValueTypeTimestamp is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeTimestamp = "TIMESTAMP"
)

// ScalarMeasureValueType_Values returns all elements of the ScalarMeasureValueType enum
func ScalarMeasureValueType_Values() []string {
	return []string{
		ScalarMeasureValueTypeDouble,
		ScalarMeasureValueTypeBigint,
		ScalarMeasureValueTypeBoolean,
		ScalarMeasureValueTypeVarchar,
		ScalarMeasureValueTypeTimestamp,
	}
}

const (
	// TableStatusActive is a TableStatus enum value
	TableStatusActive = "ACTIVE"

	// TableStatusDeleting is a TableStatus enum value
	TableStatusDeleting = "DELETING"

	// TableStatusRestoring is a TableStatus enum value
	TableStatusRestoring = "RESTORING"
)

// TableStatus_Values returns all elements of the TableStatus enum
func TableStatus_Values() []string {
	return []string{
		TableStatusActive,
		TableStatusDeleting,
		TableStatusRestoring,
	}
}

const (
	// TimeUnitMilliseconds is a TimeUnit enum value
	TimeUnitMilliseconds = "MILLISECONDS"

	// TimeUnitSeconds is a TimeUnit enum value
	TimeUnitSeconds = "SECONDS"

	// TimeUnitMicroseconds is a TimeUnit enum value
	TimeUnitMicroseconds = "MICROSECONDS"

	// TimeUnitNanoseconds is a TimeUnit enum value
	TimeUnitNanoseconds = "NANOSECONDS"
)

// TimeUnit_Values returns all elements of the TimeUnit enum
func TimeUnit_Values() []string {
	return []string{
		TimeUnitMilliseconds,
		TimeUnitSeconds,
		TimeUnitMicroseconds,
		TimeUnitNanoseconds,
	}
}
